/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.block;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class DoubleBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public DoubleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    protected abstract VoxelShape getLowerShape();

    protected abstract VoxelShape getUpperShape();

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? this.getLowerShape() : this.getUpperShape();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != doubleblockhalf ? state : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected static void removeBottomHalf(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            DoubleBlock.removeBottomHalf(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        if (blockpos.m_123342_() < 255 && ctx.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)super.m_5573_(ctx).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level levelIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        levelIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = world.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)world, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)}) : Collections.emptyList();
    }
}

