/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.block;

import com.flechazo.contact.Contact;
import com.flechazo.contact.common.block.DoubleHorizontalBlock;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.inter.ISilveroakEntry;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.tileentity.BlockEntityTypeRegistry;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.helper.VoxelShapeHelper;
import com.flechazo.contact.platform.PlatformHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends DoubleHorizontalBlock
implements EntityBlock,
ISilveroakEntry {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public final DyeColor boxColor;
    public final DyeColor flagColor;
    public static final VoxelShape LOWER_SHAPE = VoxelShapeHelper.createVoxelShape(7.0, 0.0, 7.0, 2.0, 16.0, 2.0);
    public static final VoxelShape UPPER_SHAPE_NORTH = VoxelShapeHelper.createVoxelShape(3.0, 0.0, 1.0, 10.0, 9.0, 14.0);
    public static final VoxelShape UPPER_SHAPE_EAST = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 3.0, 14.0, 9.0, 10.0);

    public MailboxBlock(DyeColor boxColor, DyeColor flagColor) {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(boxColor).m_60955_().m_60918_(SoundType.f_56742_).m_60913_(1.5f, 6.0f));
        this.boxColor = boxColor;
        this.flagColor = flagColor;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public MailboxBlock(DyeColor boxColor) {
        this(boxColor, DyeColor.RED);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((DoubleBlockHalf)state.m_61143_((Property)HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            return this.getLowerShape();
        }
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.EAST, Direction.WEST -> UPPER_SHAPE_EAST;
            default -> UPPER_SHAPE_NORTH;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    @Override
    protected VoxelShape getLowerShape() {
        return LOWER_SHAPE;
    }

    @Override
    protected VoxelShape getUpperShape() {
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!level.f_46443_) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            BlockPos topPos = state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER ? pos : pos.m_7494_();
            UUID mailboxOwner = data.getMailboxOwner((ResourceKey<Level>)level.m_46472_(), topPos);
            if (player.m_6144_() && mailboxOwner == null) {
                if (data.getMailboxPos(player.m_20148_()) == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.binding"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.switch"), true);
                }
                data.setMailboxData(player.m_20148_(), (ResourceKey<Level>)level.m_46472_(), topPos);
                MailboxManager.updateState(level, topPos);
                AdvancementManager.givePlayerAdvancement(level.m_7654_(), (ServerPlayer)player, new ResourceLocation("contact:root"));
                return InteractionResult.SUCCESS;
            }
            if (Objects.equals(mailboxOwner, player.m_20148_())) {
                SimpleContainer contents = data.getMailboxContents(mailboxOwner);
                boolean isEmpty = true;
                for (int i = 0; i < contents.m_6643_(); ++i) {
                    ItemStack parcel = contents.m_8020_(i);
                    if (parcel.m_41619_()) continue;
                    if (parcel.m_41720_() instanceof PostcardItem) {
                        AdvancementManager.givePlayerAdvancement(level.m_7654_(), (ServerPlayer)player, new ResourceLocation("contact:receive_postcard"));
                    }
                    if (parcel.m_41784_().m_128441_("AnotherWorld")) {
                        AdvancementManager.givePlayerAdvancement(level.m_7654_(), (ServerPlayer)player, new ResourceLocation("contact:from_another_world"));
                    }
                    player.m_150109_().m_150079_(parcel);
                    isEmpty = false;
                }
                data.resetMailboxContents(mailboxOwner);
                if (!isEmpty) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.pick_up"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.empty"), true);
                }
                MailboxManager.updateState(level, topPos);
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(handIn).m_41720_() instanceof IMailItem) {
                if (mailboxOwner != null) {
                    ItemStack held = player.m_21120_(handIn).m_41777_();
                    if (!held.m_41784_().m_128441_("Sender")) {
                        if (!data.isMailboxFull(mailboxOwner)) {
                            MailboxBlockEntity mailbox;
                            BlockEntity blockEntity = level.m_7702_(topPos);
                            if (blockEntity instanceof MailboxBlockEntity && (mailbox = (MailboxBlockEntity)blockEntity).checkToSend()) {
                                held.m_41784_().m_128359_("Sender", player.m_7755_().getString());
                                data.addMailboxContents(mailboxOwner, held);
                                player.m_21008_(handIn, ItemStack.f_41583_);
                                player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.deliver"), true);
                                AdvancementManager.givePlayerAdvancement(player.m_20194_(), (ServerPlayer)player, new ResourceLocation("contact:send_in_person"));
                                MailboxManager.updateState(level, topPos);
                            } else {
                                player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.check"), true);
                            }
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.full"), true);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.used"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.no_owner"), true);
                return InteractionResult.SUCCESS;
            }
            if (mailboxOwner != null) {
                PlatformHelper.getCurrentServer().m_129927_().m_11002_(mailboxOwner).ifPresent(gameProfile -> player.m_5661_((Component)Component.m_237110_((String)"message.contact.mailbox.others", (Object[])new Object[]{gameProfile.getName()}), true));
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.no_owner_tips"), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            BlockPos topPos = state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER ? pos : pos.m_7494_();
            data.removeMailboxData(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)topPos));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MailboxBlock.createTickerHelper(type, MailboxBlockEntity::tick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityTicker<? super E> entityTicker) {
        return BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get() == blockEntityType ? entityTicker : null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Override
    public ResourceLocation getRegistryID() {
        return Contact.getRL(this.boxColor.m_41065_() + "_mailbox");
    }
}

