/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.block;

import com.flechazo.contact.Contact;
import com.flechazo.contact.common.block.DoubleHorizontalBlock;
import com.flechazo.contact.common.inter.ISilveroakEntry;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.helper.VoxelShapeHelper;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PostboxBlock
extends DoubleHorizontalBlock
implements ISilveroakEntry {
    private static final Component CONTAINER_NAME = Component.m_237115_((String)"container.contact.postbox");
    private final boolean isRed;
    public static final VoxelShape LOWER_SHAPE;
    public static final VoxelShape UPPER_SHAPE;

    public PostboxBlock(boolean isRed) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56742_).m_60913_(1.5f, 6.0f));
        this.isRed = isRed;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    @Override
    protected VoxelShape getLowerShape() {
        return LOWER_SHAPE;
    }

    @Override
    protected VoxelShape getUpperShape() {
        return UPPER_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                MenuRegistry.openExtendedMenu((ServerPlayer)sp, (MenuProvider)PostboxBlock.getContainer(this.isRed), buf -> buf.writeBoolean(this.isRed));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public static MenuProvider getContainer(boolean isRed) {
        return new SimpleMenuProvider((id, inventory, player) -> new PostboxScreenHandler(id, inventory, isRed), CONTAINER_NAME);
    }

    @Override
    public ResourceLocation getRegistryID() {
        return Contact.getRL(this.isRed ? "red_postbox" : "green_postbox");
    }

    static {
        VoxelShape bottom = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 14.0, 9.0, 14.0);
        VoxelShape pillarBottom = VoxelShapeHelper.createVoxelShape(2.0, 9.0, 2.0, 12.0, 7.0, 12.0);
        VoxelShape pillarTop = VoxelShapeHelper.createVoxelShape(2.0, 0.0, 2.0, 12.0, 11.0, 12.0);
        VoxelShape topBottom = VoxelShapeHelper.createVoxelShape(0.0, 11.0, 0.0, 16.0, 3.0, 16.0);
        VoxelShape topTop = VoxelShapeHelper.createVoxelShape(3.0, 14.0, 3.0, 10.0, 2.0, 10.0);
        LOWER_SHAPE = Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)pillarBottom);
        UPPER_SHAPE = Shapes.m_83124_((VoxelShape)pillarTop, (VoxelShape[])new VoxelShape[]{topBottom, topTop});
    }
}

