/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.command;

import com.flechazo.contact.common.command.arguments.PostcardStyleArgument;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.item.ParcelItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.platform.PlatformHelper;
import com.flechazo.contact.resourse.PostcardDataManager;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ContactCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PLAYERS = (context, builder) -> {
        MinecraftServer server = PlatformHelper.getCurrentServer();
        HashSet set = Sets.newHashSet();
        if (server != null) {
            IMailboxDataProvider data = MailboxDataManager.getData(server);
            set.addAll(data.getNameToUUID().keySet());
        }
        set.add("\"@e\"");
        return SharedSuggestionProvider.m_82970_((Iterable)set, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_POSTCARDS = (context, builder) -> {
        Set<ResourceLocation> collection = PostcardDataManager.getPostcards().keySet();
        return SharedSuggestionProvider.m_82926_(collection, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext access, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"contact").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"postcard").then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"postcard", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POSTCARDS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), "", BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))).then(Commands.m_82127_((String)"deliver").then(Commands.m_82129_((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(Commands.m_82129_((String)"postcard", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POSTCARDS).then(Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).executes(context -> ContactCommand.deliverPostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.deliverPostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"parcel").then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"item1", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(Commands.m_82129_((String)"item2", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(Commands.m_82129_((String)"item3", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(Commands.m_82129_((String)"item4", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(Commands.m_82129_((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item4").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false)))))))))))))))).then(Commands.m_82127_((String)"deliver").then(Commands.m_82129_((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).then(Commands.m_82129_((String)"item1", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(Commands.m_82129_((String)"item2", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(Commands.m_82129_((String)"item3", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(Commands.m_82129_((String)"item4", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)access)).then(Commands.m_82129_((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item4").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false))))))))))))))))));
    }

    private static void deliverToPlayerMailbox(CommandSourceStack source, String target, int ticks, AtomicInteger n, ItemStack parcel) {
        IMailboxDataProvider data = MailboxDataManager.getData(source.m_81377_());
        UUID uuid = data.getNameToUUID().get(target);
        if (uuid != null) {
            if (!data.isMailboxFull(uuid)) {
                data.getMailList().add(new MailToBeSent(uuid, parcel, ticks));
                n.getAndIncrement();
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"command.contact.deliver.full", (Object[])new Object[]{target}), true);
            }
        }
    }

    private static int deliverParcel(CommandSourceStack source, String target, int ticks, String sender, boolean isEnder, ItemStack ... list) {
        AtomicInteger n = new AtomicInteger(0);
        SimpleContainer contents = new SimpleContainer(4);
        for (int i = 0; i < list.length; ++i) {
            contents.m_6836_(i, list[i]);
        }
        ItemStack parcel = ParcelItem.getParcel(contents, isEnder, sender);
        if (target.equals("@e")) {
            IMailboxDataProvider data = MailboxDataManager.getData(source.m_81377_());
            data.getNameToUUID().keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, parcel));
        } else {
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, parcel);
        }
        if (n.get() == 1 && target.equals("@e")) {
            source.m_288197_(() -> Component.m_237110_((String)"command.contact.deliver.success.single", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41786_(), target}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"command.contact.deliver.success.multiple", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41786_(), n.get()}), true);
        }
        return n.get();
    }

    private static int giveParcel(CommandSourceStack source, Collection<ServerPlayer> targets, String sender, boolean isEnder, ItemStack ... list) {
        SimpleContainer contents = new SimpleContainer(4);
        for (int i = 0; i < list.length; ++i) {
            contents.m_6836_(i, list[i]);
        }
        ItemStack parcel = ParcelItem.getParcel(contents, isEnder, sender);
        ContactCommand.giveParcelToPlayers(targets, parcel);
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41786_(), ((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41786_(), targets.size()}), true);
        }
        return targets.size();
    }

    private static int deliverPostcard(CommandSourceStack source, ResourceLocation id, String target, int ticks, String sender, boolean isEnder, String text) {
        text = text.replace("\\n", "\n");
        AtomicInteger n = new AtomicInteger(0);
        if (target.equals("@e")) {
            ItemStack postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.m_41784_().m_128359_("Sender", sender);
            IMailboxDataProvider data = MailboxDataManager.getData(source.m_81377_());
            data.getNameToUUID().keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, postcard));
        } else {
            ItemStack postcard = PostcardItem.setText(PostcardItem.getPostcard(id, false), text);
            postcard.m_41784_().m_128359_("Sender", sender);
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, postcard);
        }
        if (n.get() == 1 && !target.equals("@e")) {
            source.m_288197_(() -> Component.m_237110_((String)"command.contact.deliver.success.single", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get()).m_41786_(), target}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"command.contact.deliver.success.multiple", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get()).m_41786_(), n.get()}), true);
        }
        return n.get();
    }

    private static int givePostcard(CommandSourceStack source, ResourceLocation id, Collection<ServerPlayer> targets, String sender, boolean isEnder, String text) {
        ItemStack postcard;
        text = text.replace("\\n", "\n");
        if (sender.isEmpty()) {
            postcard = PostcardItem.getPostcard(id, isEnder);
        } else {
            postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.m_41784_().m_128359_("Sender", sender);
        }
        ContactCommand.giveParcelToPlayers(targets, postcard);
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, new ItemStack((ItemLike)ItemRegistry.POSTCARD.get()).m_41786_(), ((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, new ItemStack((ItemLike)ItemRegistry.POSTCARD.get()).m_41786_(), targets.size()}), true);
        }
        return targets.size();
    }

    private static void giveParcelToPlayers(Collection<ServerPlayer> targets, ItemStack parcel) {
        for (ServerPlayer serverPlayer : targets) {
            boolean flag = serverPlayer.m_150109_().m_36054_(parcel);
            if (flag) {
                ItemEntity itemEntity = serverPlayer.m_36176_(parcel, false);
                if (itemEntity != null) {
                    itemEntity.m_32065_();
                }
                serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverPlayer.m_217043_().m_188501_() - serverPlayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.f_36095_.m_38946_();
                continue;
            }
            ItemEntity itementity = serverPlayer.m_36176_(parcel, false);
            if (itementity == null) continue;
            itementity.m_32061_();
            itementity.m_32052_(serverPlayer.m_20148_());
        }
    }
}

