/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.entity;

import com.flechazo.contact.common.entity.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class PostcardEntity
extends HangingEntity {
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(PostcardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.m_135353_(PostcardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean fixed;

    public PostcardEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public PostcardEntity(Level level, BlockPos pos, Direction facing) {
        this((EntityType<? extends HangingEntity>)((EntityType)EntityTypeRegistry.POSTCARD.get()), level, pos, facing);
    }

    public PostcardEntity(EntityType<? extends HangingEntity> type, Level world, BlockPos pos, Direction facing) {
        super(type, world, pos);
        this.m_6022_(facing);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.0f;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(ROTATION, (Object)0);
    }

    protected void m_6022_(Direction direction) {
        Validate.notNull((Object)direction);
        this.f_31699_ = direction;
        if (direction.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * direction.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    protected void m_7087_() {
        if (this.f_31699_ == null) {
            return;
        }
        double e = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * 0.46875;
        double f = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * 0.46875;
        double g = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * 0.46875;
        this.m_20343_(e, f, g);
        double h = this.m_7076_();
        double i = this.m_7068_();
        double j = this.m_7076_();
        Direction.Axis axis = this.f_31699_.m_122434_();
        switch (axis) {
            case X: {
                h = 1.0;
                break;
            }
            case Y: {
                i = 1.0;
                break;
            }
            case Z: {
                j = 1.0;
            }
        }
        this.m_20011_(new AABB(e - (h /= 32.0), f - (i /= 32.0), g - (j /= 32.0), e + h, f + i, g + j));
    }

    public boolean m_7088_() {
        if (this.fixed) {
            return true;
        }
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        BlockState blockState = this.m_9236_().m_8055_(this.f_31698_.m_121945_(this.f_31699_.m_122424_()));
        if (!(blockState.m_280296_() || this.f_31699_.m_122434_().m_122479_() && DiodeBlock.m_52586_((BlockState)blockState))) {
            return false;
        }
        return this.m_9236_().m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty();
    }

    public void m_6478_(MoverType moverType, Vec3 movement) {
        if (!this.fixed) {
            super.m_6478_(moverType, movement);
        }
    }

    public void m_5997_(double deltaX, double deltaY, double deltaZ) {
        if (!this.fixed) {
            super.m_5997_(deltaX, deltaY, deltaZ);
        }
    }

    public float m_6143_() {
        return 0.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.fixed) {
            if (source.m_269150_().m_203565_(DamageTypes.f_268724_) || source.m_19390_()) {
                return super.m_6469_(source, amount);
            }
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public int m_7076_() {
        return 12;
    }

    public int m_7068_() {
        return 12;
    }

    public boolean m_6783_(double distance) {
        double d;
        double d2 = 16.0;
        return distance < d * (d2 *= 64.0 * ItemFrame.m_20150_());
    }

    public void m_5553_(@Nullable Entity entity) {
        this.m_5496_(this.getBreakSound(), 1.0f, 1.0f);
        this.dropPostcard(entity);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.f_12014_;
    }

    public void m_7084_() {
        this.m_5496_(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.f_12015_;
    }

    private void dropPostcard(@Nullable Entity entity) {
        if (this.fixed) {
            return;
        }
        ItemStack postcard = this.getPostcard();
        this.setHeldItemStack(ItemStack.f_41583_);
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        if (!postcard.m_41619_()) {
            postcard = postcard.m_41777_();
            this.m_19983_(postcard);
        }
    }

    public ItemStack getPostcard() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    public void setHeldItemStack(ItemStack value) {
        if (!value.m_41619_()) {
            value = value.m_41777_();
            value.m_41764_(1);
        }
        this.setAsStackHolder(value);
        this.m_20088_().m_135381_(ITEM_STACK, (Object)value);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (data.equals(ITEM_STACK)) {
            this.setAsStackHolder(this.getPostcard());
        }
    }

    private void setAsStackHolder(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41609_() != this) {
            stack.m_41636_((Entity)this);
        }
        this.m_7087_();
    }

    public int getRotation() {
        return (Integer)this.m_20088_().m_135370_(ROTATION);
    }

    private void setRotation(int value) {
        this.m_20088_().m_135381_(ROTATION, (Object)(value % 16));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.getPostcard().m_41619_()) {
            tag.m_128365_("Item", (Tag)this.getPostcard().m_41739_(new CompoundTag()));
            tag.m_128344_("ItemRotation", (byte)this.getRotation());
        }
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
        tag.m_128379_("Invisible", this.m_20145_());
        tag.m_128379_("Fixed", this.fixed);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag compoundTag = tag.m_128469_("Item");
        if (!compoundTag.m_128456_()) {
            ItemStack postcard = ItemStack.m_41712_((CompoundTag)compoundTag);
            this.setHeldItemStack(postcard);
            this.setRotation(tag.m_128445_("ItemRotation"));
        }
        this.m_6022_(Direction.m_122376_((int)tag.m_128445_("Facing")));
        this.m_6842_(tag.m_128471_("Invisible"));
        this.fixed = tag.m_128471_("Fixed");
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        boolean isEmpty;
        boolean bl = isEmpty = !this.getPostcard().m_41619_();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (this.m_9236_().m_5776_()) {
            return isEmpty ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!isEmpty) {
            this.m_6469_(this.m_269291_().m_269075_(player), 1.0f);
        }
        this.m_5496_(this.getRotateItemSound(), 1.0f, 1.0f);
        if (this.m_6350_().m_122411_() > 1) {
            this.setRotation((this.getRotation() + 1) % 3);
        } else {
            this.setRotation(this.getRotation() + 1);
        }
        return InteractionResult.CONSUME;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.f_12017_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6022_(Direction.m_122376_((int)packet.m_131509_()));
    }

    public ItemStack m_142340_() {
        return this.getPostcard();
    }

    public float m_213816_() {
        Direction direction = this.m_6350_();
        int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
        return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + this.getRotation() * 45 + i));
    }
}

