/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.handler;

import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.storage.PlayerMailboxData;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class MailboxManager {
    private static final List<MailToBeSent> READY_TO_REMOVE = Lists.newArrayList();
    private static int updateTick = 0;

    public static void onServerTick(MinecraftServer server) {
        IMailboxDataProvider data = MailboxDataManager.getData(server);
        ++updateTick;
        if ((updateTick %= 20) == 0) {
            for (MailToBeSent mail : data.getMailList()) {
                UUID uuid;
                mail.tick(20);
                if (!mail.isReady() || !data.addMailboxContents(uuid = mail.getUUID(), mail.getContents())) continue;
                ServerPlayer player = server.m_6846_().m_11259_(uuid);
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.contact.mailbox.new_mail"), false);
                }
                MailboxManager.updateState(uuid, data.data());
                READY_TO_REMOVE.add(mail);
            }
            if (!READY_TO_REMOVE.isEmpty()) {
                data.getMailList().removeAll(READY_TO_REMOVE);
                READY_TO_REMOVE.clear();
            }
        }
    }

    public static void updateState(UUID uuid, PlayerMailboxData data) {
        GlobalPos posData = data.getMailboxPos(uuid);
        if (posData != null) {
            MailboxManager.updateState((Level)PlatformHelper.getCurrentServer().m_129880_(posData.m_122640_()), posData.m_122646_());
        }
    }

    public static void updateState(Level level, BlockPos pos) {
        BlockEntity te;
        if (level != null && level.m_46805_(pos) && (te = level.m_7702_(pos)) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)te).refreshStatus();
        }
    }

    public static int getDeliveryTicks(ResourceKey<Level> fromLevel, BlockPos fromPos, ResourceKey<Level> toLevel, BlockPos toPos) {
        int distance;
        int time = 0;
        if (fromLevel != toLevel) {
            time += ContactCommonConfig.getTicksToAnotherWorld();
        }
        if ((distance = Math.abs(fromPos.m_123341_() - toPos.m_123341_()) + Math.abs(fromPos.m_123343_() - toPos.m_123343_())) > 9000) {
            distance = 9000;
        }
        return time += ContactCommonConfig.getPostalSpeed() * distance;
    }

    public static int getDeliveryTicks(GlobalPos fromPos, GlobalPos toPos) {
        return MailboxManager.getDeliveryTicks((ResourceKey<Level>)fromPos.m_122640_(), fromPos.m_122646_(), (ResourceKey<Level>)toPos.m_122640_(), toPos.m_122646_());
    }
}

