/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.item;

import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.entity.PostcardEntity;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.item.NormalItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PostcardItem
extends NormalItem
implements IMailItem {
    private final boolean isEnderType;

    public PostcardItem(String id, boolean isEnderType) {
        super(new ResourceLocation("contact", id), new Item.Properties().m_41487_(1), null);
        this.isEnderType = isEnderType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player user, InteractionHand hand) {
        ItemStack itemstack = user.m_21120_(hand);
        if (level.f_46443_) {
            if (itemstack.m_41784_().m_128441_("Sender")) {
                ClientProxy.openPostcardToRead(itemstack);
            } else {
                ClientProxy.openPostcardToEdit(itemstack, user, hand);
            }
        }
        user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level;
        PostcardEntity postcardEntity;
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        if (player != null) {
            if (!player.m_6144_()) {
                return InteractionResult.PASS;
            }
            if (!this.canPlaceOn(player, direction, itemStack, blockPos2)) {
                return InteractionResult.FAIL;
            }
        }
        if ((postcardEntity = new PostcardEntity(level = context.m_43725_(), blockPos2, direction)).m_7088_()) {
            if (!level.f_46443_) {
                postcardEntity.m_7084_();
                level.m_142346_((Entity)player, GameEvent.f_157810_, postcardEntity.m_31748_());
                level.m_7967_((Entity)postcardEntity);
                postcardEntity.setHeldItemStack(itemStack.m_41777_());
            }
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean canPlaceOn(Player player, Direction side, ItemStack stack, BlockPos pos) {
        return !player.m_9236_().m_151570_(pos) && player.m_36204_(pos, side, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41784_().m_128441_("Info")) {
            MutableComponent background = Component.m_237115_((String)("tooltip.contact.postcard." + stack.m_41784_().m_128469_("Info").m_128461_("ID"))).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.contact.postcard.background", (Object[])new Object[]{background}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_41784_().m_128441_("CardID")) {
            ResourceLocation id = new ResourceLocation(stack.m_41784_().m_128461_("CardID"));
            MutableComponent background = Component.m_237115_((String)("tooltip.postcard." + id.m_135827_() + "." + id.m_135815_())).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.contact.postcard.background", (Object[])new Object[]{background}).m_130940_(ChatFormatting.GRAY));
        }
        this.addSenderInfoTooltip(stack, level, tooltip, flag);
    }

    @Override
    public boolean isEnderType() {
        return this.isEnderType;
    }

    public static ItemStack getPostcard(ResourceLocation id, boolean isEnderType) {
        ItemStack postcard = new ItemStack(isEnderType ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("CardID", id.toString());
        postcard.m_41751_(nbt);
        return postcard;
    }

    public static ItemStack setText(ItemStack postcard, String text) {
        postcard.m_41700_("Text", (Tag)StringTag.m_129297_((String)text));
        return postcard;
    }

    public static String getText(ItemStack postcard) {
        if (postcard.m_41782_()) {
            return postcard.m_41784_().m_128461_("Text");
        }
        return "";
    }
}

