/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.storage;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class MailToBeSent {
    private final UUID uuid;
    private final SimpleContainer contents;
    private long ticks;

    public MailToBeSent(CompoundTag tag) {
        this.uuid = UUID.fromString(tag.m_128461_("MailUUID"));
        this.ticks = tag.m_128451_("MailTicks");
        this.contents = new SimpleContainer(1);
        this.contents.m_7797_(tag.m_128437_("MailContents", 10));
    }

    public MailToBeSent(UUID uuid, ItemStack contents, long ticks) {
        this.uuid = uuid;
        this.contents = new SimpleContainer(1);
        this.contents.m_6836_(0, contents.m_41777_());
        this.ticks = ticks;
    }

    public ItemStack getContents() {
        return this.contents.m_8020_(0).m_41777_();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isReady() {
        return this.ticks <= 0L;
    }

    public void tick(int tick) {
        if (this.ticks > 0L) {
            this.ticks -= (long)tick;
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("MailUUID", this.uuid.toString());
        nbt.m_128356_("MailTicks", this.ticks);
        nbt.m_128365_("MailContents", (Tag)this.contents.m_7927_());
        return nbt;
    }
}

