/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.storage;

import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.network.ActionMessage;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerMailboxData {
    public final Map<String, UUID> nameToUUID = Maps.newTreeMap();
    public final Map<UUID, SimpleContainer> uuidToContents = Maps.newHashMap();
    private final Map<UUID, GlobalPos> uuidToLocation = Maps.newHashMap();
    private final Map<GlobalPos, UUID> locationToPlayer = Maps.newHashMap();
    public final List<MailToBeSent> mailList = Lists.newArrayList();

    public SimpleContainer getMailboxContents(UUID uuid) {
        return this.uuidToContents.getOrDefault(uuid, new SimpleContainer(24));
    }

    public boolean isMailboxEmpty(UUID uuid) {
        SimpleContainer contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return true;
        }
        for (int i = 0; i < contents.m_6643_(); ++i) {
            if (contents.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isMailboxFull(UUID uuid) {
        SimpleContainer contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return false;
        }
        for (int i = 0; i < contents.m_6643_(); ++i) {
            if (!contents.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean addMailboxContents(UUID uuid, ItemStack parcelIn) {
        SimpleContainer mailbox = this.getMailboxContents(uuid);
        if (!this.isMailboxFull(uuid)) {
            for (int i = 0; i < mailbox.m_6643_(); ++i) {
                if (!mailbox.m_8020_(i).m_41619_()) continue;
                mailbox.m_6836_(i, parcelIn);
                this.setMailboxContents(uuid, mailbox);
                ServerPlayer player = PlatformHelper.getCurrentServer().m_6846_().m_11259_(uuid);
                if (player != null) {
                    ActionMessage packet = ActionMessage.create(0);
                    packet.sendTo(player);
                }
                return true;
            }
        }
        return false;
    }

    public void setMailboxContents(UUID uuid, SimpleContainer contents) {
        this.uuidToContents.put(uuid, contents);
    }

    public void resetMailboxContents(UUID uuid) {
        this.setMailboxContents(uuid, new SimpleContainer(24));
    }

    @Nullable
    public UUID getMailboxOwner(ResourceKey<Level> level, BlockPos pos) {
        return this.locationToPlayer.get(GlobalPos.m_122643_(level, (BlockPos)pos));
    }

    @Nullable
    public GlobalPos getMailboxPos(UUID uuid) {
        return this.uuidToLocation.get(uuid);
    }

    public void setMailboxData(UUID uuid, ResourceKey<Level> level, BlockPos pos) {
        BlockEntity newTE;
        GlobalPos newPos = GlobalPos.m_122643_(level, (BlockPos)pos);
        GlobalPos oldPos = this.uuidToLocation.get(uuid);
        if (oldPos != null) {
            BlockEntity oldTE;
            this.locationToPlayer.remove(oldPos);
            ServerLevel oldLevel = PlatformHelper.getCurrentServer().m_129880_(oldPos.m_122640_());
            if (oldLevel != null && oldLevel.m_46805_(oldPos.m_122646_()) && (oldTE = oldLevel.m_7702_(oldPos.m_122646_())) instanceof MailboxBlockEntity) {
                ((MailboxBlockEntity)oldTE).refreshStatus();
            }
        }
        this.uuidToLocation.put(uuid, newPos);
        this.locationToPlayer.put(newPos, uuid);
        ServerLevel newWorld = PlatformHelper.getCurrentServer().m_129880_(level);
        if (newWorld != null && newWorld.m_46805_(newPos.m_122646_()) && (newTE = newWorld.m_7702_(newPos.m_122646_())) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)newTE).refreshStatus();
        }
    }

    public void removeMailboxData(GlobalPos pos) {
        GlobalPos mailboxPos;
        UUID uuid = this.locationToPlayer.remove(pos);
        if (uuid != null && Objects.equals(mailboxPos = this.uuidToLocation.get(uuid), pos)) {
            this.uuidToLocation.remove(uuid);
        }
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        int n = this.uuidToContents.size();
        tag.m_128405_("MapDataSize", n);
        int i = 0;
        for (UUID uuid : this.uuidToContents.keySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("UUID", uuid.toString());
            compoundTag.m_128365_("Contents", (Tag)this.uuidToContents.getOrDefault(uuid, new SimpleContainer(24)).m_7927_());
            GlobalPos globalPos = this.uuidToLocation.get(uuid);
            if (globalPos != null) {
                ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)globalPos.m_122640_().m_135782_()).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).ifPresent(world -> compoundTag.m_128365_("MailboxDimension", world));
                compoundTag.m_128405_("MailboxX", globalPos.m_122646_().m_123341_());
                compoundTag.m_128405_("MailboxY", globalPos.m_122646_().m_123342_());
                compoundTag.m_128405_("MailboxZ", globalPos.m_122646_().m_123343_());
            }
            tag.m_128365_("MapData" + i, (Tag)compoundTag);
            ++i;
        }
        tag.m_128405_("MailListSize", this.mailList.size());
        for (i = 0; i < this.mailList.size(); ++i) {
            tag.m_128365_("MailListData" + i, (Tag)this.mailList.get(i).writeToNBT());
        }
        tag.m_128405_("NameMapSize", this.nameToUUID.size());
        i = 0;
        for (String name : this.nameToUUID.keySet()) {
            tag.m_128359_("NameMap" + i, name);
            tag.m_128359_("NameMapUUID" + i, this.nameToUUID.get(name).toString());
            ++i;
        }
        return tag;
    }

    public void readFromNBT(CompoundTag tag) {
        UUID uuid;
        CompoundTag compoundTag;
        int i;
        this.uuidToContents.clear();
        this.uuidToLocation.clear();
        this.locationToPlayer.clear();
        this.mailList.clear();
        this.nameToUUID.clear();
        int n = tag.m_128451_("MapDataSize");
        for (i = 0; i < n; ++i) {
            compoundTag = tag.m_128469_("MapData" + i);
            uuid = UUID.fromString(compoundTag.m_128461_("UUID"));
            SimpleContainer contents = new SimpleContainer(24);
            contents.m_7797_(compoundTag.m_128437_("Contents", 10));
            this.uuidToContents.put(uuid, contents);
            if (!compoundTag.m_128441_("MailboxDimension")) continue;
            BlockPos mailboxPos = new BlockPos(compoundTag.m_128451_("MailboxX"), compoundTag.m_128451_("MailboxY"), compoundTag.m_128451_("MailboxZ"));
            ResourceKey mailboxWorld = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("MailboxDimension")).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).orElse(Level.f_46428_);
            GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)mailboxWorld, (BlockPos)mailboxPos);
            this.uuidToLocation.put(uuid, globalPos);
            this.locationToPlayer.put(globalPos, uuid);
        }
        n = tag.m_128451_("MailListSize");
        for (i = 0; i < n; ++i) {
            compoundTag = tag.m_128469_("MailListData" + i);
            MailToBeSent mail = new MailToBeSent(compoundTag);
            this.mailList.add(mail);
        }
        n = tag.m_128451_("NameMapSize");
        for (i = 0; i < n; ++i) {
            String name = tag.m_128461_("NameMap" + i);
            uuid = UUID.fromString(tag.m_128461_("NameMapUUID" + i));
            this.nameToUUID.put(name, uuid);
        }
    }
}

