/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.tileentity;

import com.flechazo.contact.common.block.MailboxBlock;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.tileentity.BlockEntityTypeRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MailboxBlockEntity
extends BlockEntity {
    private boolean isOpened = false;
    private boolean needRefresh = false;
    private int refreshTicks = 20;
    private int checkToSendTicks = 0;
    private int angel = 0;

    public MailboxBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isOpened = nbt.m_128471_("IsOpened");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("IsOpened", this.isOpened);
    }

    public boolean checkToSend() {
        if (this.checkToSendTicks <= 0) {
            this.checkToSendTicks = 60;
            return false;
        }
        return true;
    }

    public void refreshStatus() {
        if (!this.f_58857_.f_46443_) {
            boolean now;
            IMailboxDataProvider data = MailboxDataManager.getData(this.f_58857_);
            boolean bl = now = !data.isMailboxEmpty(data.getMailboxOwner((ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_()));
            if (now != this.isOpened) {
                this.needRefresh = true;
                this.isOpened = now;
                this.refresh();
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MailboxBlockEntity blockEntity) {
        if (!level.f_46443_) {
            if (blockEntity.refreshTicks >= 0) {
                --blockEntity.refreshTicks;
            }
            if (blockEntity.checkToSendTicks > 0) {
                --blockEntity.checkToSendTicks;
            }
            if (blockEntity.needRefresh || blockEntity.refreshTicks == 0) {
                blockEntity.refreshStatus();
                BlockState down = level.m_8055_(pos.m_7495_());
                if (!(down.m_60734_() instanceof MailboxBlock) || (Boolean)down.m_61143_((Property)MailboxBlock.OPEN) == blockEntity.isOpened) {
                    blockEntity.needRefresh = false;
                    return;
                }
                level.m_46597_(pos.m_7495_(), (BlockState)down.m_61124_((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(blockEntity.isOpened)));
                blockEntity.needRefresh = false;
                if (state.m_60734_() instanceof MailboxBlock) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(blockEntity.isOpened)));
                }
            }
        } else if (blockEntity.isOpened) {
            ++blockEntity.angel;
            blockEntity.angel %= 40;
        }
    }

    private void refresh() {
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
            List players = ((ServerLevel)this.f_58857_).m_7726_().f_8325_.m_183262_(new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4), false);
            for (ServerPlayer player : players) {
                player.f_8906_.m_9829_((Packet)packet);
            }
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public int getAngel() {
        return this.angel;
    }
}

