/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.forge.storage;

import com.flechazo.contact.common.storage.PlayerMailboxData;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="contact")
public class MailboxDataCapability {
    public static final Capability<PlayerMailboxData> MAILBOX_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerMailboxData>(){});
    public static final ResourceLocation ID = new ResourceLocation("contact", "mailbox_data");

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Level> event) {
        if (((Level)event.getObject()).m_46472_() == Level.f_46428_) {
            event.addCapability(ID, (ICapabilityProvider)new MailboxDataProvider());
        }
    }

    public static class MailboxDataProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final PlayerMailboxData data = new PlayerMailboxData();
        private final LazyOptional<PlayerMailboxData> optional = LazyOptional.of(() -> this.data);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == MAILBOX_DATA ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.data.writeToNBT(tag);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.data.readFromNBT(nbt);
        }
    }
}

