/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.helper;

public final class ColorHelper {
    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static float getRedF(int color) {
        return (float)ColorHelper.getRed(color) / 255.0f;
    }

    public static float getGreenF(int color) {
        return (float)ColorHelper.getGreen(color) / 255.0f;
    }

    public static float getBlueF(int color) {
        return (float)ColorHelper.getBlue(color) / 255.0f;
    }

    public static float getAlphaF(int color) {
        return (float)ColorHelper.getAlpha(color) / 255.0f;
    }

    public static int simplyMixColor(int color1, float alpha1, int color2, float alpha2) {
        int red = (int)((float)ColorHelper.getRed(color1) * alpha1 + (float)ColorHelper.getRed(color2) * alpha2);
        int green = (int)((float)ColorHelper.getGreen(color1) * alpha1 + (float)ColorHelper.getGreen(color2) * alpha2);
        int blue = (int)((float)ColorHelper.getBlue(color1) * alpha1 + (float)ColorHelper.getBlue(color2) * alpha2);
        int alpha = (int)((float)ColorHelper.getAlpha(color1) * alpha1 + (float)ColorHelper.getAlpha(color2) * alpha2);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

