/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.helper;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Transformation;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class GuiHelper {
    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder wr = tesselator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        wr.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        tesselator.m_85914_();
    }

    public static void drawLayer(PoseStack poseStack, int x, int y, TexturePos pos, int z) {
        GuiHelper.drawTexturedModalRect(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), z);
    }

    public static void drawLayer(PoseStack poseStack, int x, int y, TexturePos pos) {
        GuiHelper.drawTexturedModalRect(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), 0.0f);
    }

    public static void drawLayer(GuiGraphics guiGraphics, int x, int y, ResourceLocation rl, TexturePos pos) {
        guiGraphics.m_280218_(rl, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight());
    }

    public static void drawLayerBySize(GuiGraphics guiGraphics, ResourceLocation rl, int x, int y, TexturePos pos, int textureWidth, int textureHeight) {
        guiGraphics.m_280411_(rl, x, y, pos.getWidth(), pos.getHeight(), (float)pos.getX(), (float)pos.getY(), pos.getWidth(), pos.getHeight(), textureWidth, textureHeight);
    }

    public static void drawLayerBySize(GuiGraphics guiGraphics, ResourceLocation rl, int x, int y, TexturePos pos) {
        GuiHelper.drawLayerBySize(guiGraphics, rl, x, y, pos, pos.getWidth(), pos.getHeight());
    }

    public static void renderIconButton(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY, int z, ResourceLocation texture, IconButton button, TexturePos normalPos, TexturePos hoveredPos, TexturePos pressedPos) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        if (button.isPressed()) {
            GuiHelper.drawLayer(guiGraphics.m_280168_(), button.m_252754_(), button.m_252907_(), pressedPos);
            RenderSystem.disableBlend();
            return;
        }
        if (button.m_274382_()) {
            GuiHelper.drawLayer(guiGraphics.m_280168_(), button.m_252754_(), button.m_252907_(), hoveredPos);
            RenderSystem.disableBlend();
            return;
        }
        GuiHelper.drawLayer(guiGraphics.m_280168_(), button.m_252754_(), button.m_252907_(), normalPos);
        RenderSystem.disableBlend();
        button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void renderButton(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY, int z, ResourceLocation texture, Button button, TexturePos normalPos, TexturePos hoveredPos) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        if (button.m_274382_()) {
            GuiHelper.drawLayer(guiGraphics.m_280168_(), button.m_252754_(), button.m_252907_(), hoveredPos);
        } else {
            GuiHelper.drawLayer(guiGraphics.m_280168_(), button.m_252754_(), button.m_252907_(), normalPos);
        }
        RenderSystem.disableBlend();
        button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void drawTransparentStringDefault(Font font, String text, float x, float y, int color, boolean shadow) {
        GuiHelper.drawSpecialString(font, text, x, y, color, shadow, true, 0, 0xF000F0);
    }

    public static void drawSpecialString(Font font, String text, float x, float y, int color, boolean shadow, boolean transparent, int colorBackground, int packedLight) {
        MultiBufferSource.BufferSource iRenderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_271703_(text, x, y, color, shadow, Transformation.m_121093_().m_252783_(), (MultiBufferSource)iRenderTypeBuffer, transparent ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, colorBackground, packedLight);
        iRenderTypeBuffer.m_109911_();
    }

    public static void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int weight, int height, List<Component> list) {
        if (x <= mouseX && mouseX <= x + weight && y <= mouseY && mouseY <= y + height) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void drawFluidTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height, Component name, int amount) {
        if (amount != 0) {
            ArrayList list = Lists.newArrayList((Object[])new Component[]{name});
            DecimalFormat df = new DecimalFormat("#,###");
            list.add(Component.m_237113_((String)(df.format(amount) + " mB")).m_130940_(ChatFormatting.GRAY));
            GuiHelper.drawTooltip(guiGraphics, mouseX, mouseY, x, y, width, height, list);
        }
    }

    private static float getCorrespondingUV(float min, float max, int uv) {
        return min + (max - min) * (float)uv / 16.0f;
    }

    static void innerBlit(int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderSystem.enableBlend();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x0, (double)y1, (double)z).m_7421_(u0, v1).m_5752_();
        buffer.m_5483_((double)x1, (double)y1, (double)z).m_7421_(u1, v1).m_5752_();
        buffer.m_5483_((double)x1, (double)y0, (double)z).m_7421_(u1, v0).m_5752_();
        buffer.m_5483_((double)x0, (double)y0, (double)z).m_7421_(u0, v0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }
}

