/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.Contact;
import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.screenhandler.PackageScreenHandler;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.screenhandler.RedPacketEnvelopeScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ActionMessage {
    private static final ResourceLocation ID = new ResourceLocation("contact", "action");
    private final int action;
    private final String extra;

    public ActionMessage(int action, String extra) {
        this.action = action;
        this.extra = extra;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.action);
        buf.m_130072_(this.extra != null ? this.extra : "", Short.MAX_VALUE);
    }

    public static ActionMessage decode(FriendlyByteBuf buf) {
        try {
            int action = buf.readInt();
            String extra = buf.m_130136_(Short.MAX_VALUE);
            return new ActionMessage(action, extra.isEmpty() ? null : extra);
        }
        catch (Exception e) {
            Contact.error("[ActionMessage/decode] Failed to decode, buf readableBytes=" + buf.readableBytes(), e);
            throw e;
        }
    }

    public void handleClient() {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft client = Minecraft.m_91087_();
        if (this.action == 0) {
            ClientProxy.notifyNewMail(client);
        } else if (this.action == 1 && client.f_91074_ != null && (abstractContainerMenu = client.f_91074_.f_36096_) instanceof PostboxScreenHandler) {
            PostboxScreenHandler container = (PostboxScreenHandler)abstractContainerMenu;
            container.status = (byte)2;
        }
    }

    public void handleServer(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (this.action == 0) {
            ActionMessage.packParcel(player, this.extra);
        }
    }

    public static ActionMessage create(int action) {
        return new ActionMessage(action, null);
    }

    public static ActionMessage create(int action, String extra) {
        return new ActionMessage(action, extra);
    }

    private static void packParcel(ServerPlayer player, String extra) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof PackageScreenHandler) {
            PackageScreenHandler screenHandler = (PackageScreenHandler)abstractContainerMenu;
            screenHandler.isPacked = true;
            if (screenHandler instanceof RedPacketEnvelopeScreenHandler) {
                RedPacketEnvelopeScreenHandler redPacket = (RedPacketEnvelopeScreenHandler)screenHandler;
                redPacket.blessings = extra;
            }
            player.m_6915_();
        }
    }

    public void sendTo(ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public void sendToServer() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static void registerC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ID, (buf, ctx) -> {
            ActionMessage msg = ActionMessage.decode(buf);
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            if (player != null) {
                player.f_8924_.execute(() -> msg.handleServer(player));
            }
        });
    }

    public static void registerS2C() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ID, (buf, ctx) -> {
            ActionMessage msg = ActionMessage.decode(buf);
            Minecraft mc = Minecraft.m_91087_();
            mc.execute(msg::handleClient);
        });
    }
}

