/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AddresseeDataMessage {
    private static final ResourceLocation ID = new ResourceLocation("contact", "addressee_data");
    private final List<String> names;
    private final List<Integer> ticks;

    public AddresseeDataMessage(List<String> names, List<Integer> ticks) {
        this.names = names;
        this.ticks = ticks;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.names.size());
        for (String name : this.names) {
            buf.m_130072_(name, Short.MAX_VALUE);
        }
        Iterator<Object> iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            int tick = (Integer)iterator.next();
            buf.writeInt(tick);
        }
    }

    public static AddresseeDataMessage decode(FriendlyByteBuf buf) {
        int i;
        int size = buf.readInt();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            names.add(buf.m_130136_(Short.MAX_VALUE));
        }
        for (i = 0; i < size; ++i) {
            ticks.add(buf.readInt());
        }
        return new AddresseeDataMessage(names, ticks);
    }

    public void handleClient() {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = client.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof PostboxScreenHandler) {
            PostboxScreenHandler container = (PostboxScreenHandler)abstractContainerMenu;
            container.names = this.names;
            container.ticks = this.ticks;
        }
    }

    public static AddresseeDataMessage create(List<String> names, List<Integer> ticks) {
        return new AddresseeDataMessage(names, ticks);
    }

    public void sendTo(ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static void registerS2C() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ID, (buf, ctx) -> {
            AddresseeDataMessage msg = AddresseeDataMessage.decode(buf);
            Minecraft mc = Minecraft.m_91087_();
            mc.execute(msg::handleClient);
        });
    }
}

