/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.network.ActionMessage;
import com.flechazo.contact.network.AddresseeDataMessage;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EnquireAddresseeMessage {
    private static final ResourceLocation ID = new ResourceLocation("contact", "enquire_addressee");
    private final String nameIn;
    private final boolean shouldSend;

    public EnquireAddresseeMessage(String name, boolean shouldSend) {
        this.nameIn = name;
        this.shouldSend = shouldSend;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130072_(this.nameIn, Short.MAX_VALUE);
        buf.writeBoolean(this.shouldSend);
    }

    public static EnquireAddresseeMessage decode(FriendlyByteBuf buf) {
        String name = buf.m_130136_(Short.MAX_VALUE);
        boolean shouldSend = buf.readBoolean();
        return new EnquireAddresseeMessage(name, shouldSend);
    }

    public void handleServer(ServerPlayer player) {
        if (player == null || this.nameIn.isEmpty()) {
            return;
        }
        IMailboxDataProvider data = MailboxDataManager.getData(player.f_8924_);
        String lowerIn = this.nameIn.toLowerCase(Locale.ROOT);
        if (lowerIn.equals("@e") && player.f_8924_.m_129944_(player.m_36316_()) >= 2) {
            this.handleAdminBroadcast(player, data);
            return;
        }
        this.handleNormalEnquiry(player, data, lowerIn);
    }

    private void handleAdminBroadcast(ServerPlayer player, IMailboxDataProvider data) {
        if (this.shouldSend) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof PostboxScreenHandler) {
                PostboxScreenHandler container = (PostboxScreenHandler)abstractContainerMenu;
                ItemStack parcel = container.parcel.m_8020_(0).m_41777_();
                parcel.m_41784_().m_128359_("Sender", player.m_7755_().getString());
                for (UUID uuid : data.getNameToUUID().values()) {
                    data.getMailList().add(new MailToBeSent(uuid, parcel.m_41777_(), 0L));
                }
                ActionMessage.create(1).sendTo(player);
                container.parcel.m_6836_(0, ItemStack.f_41583_);
            }
        } else {
            ArrayList<String> names = new ArrayList<String>();
            names.add("@e");
            ArrayList<Integer> ticks = new ArrayList<Integer>();
            ticks.add(0);
            AddresseeDataMessage.create(names, ticks).sendTo(player);
        }
    }

    private void handleNormalEnquiry(ServerPlayer player, IMailboxDataProvider data, String lowerIn) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : data.getNameToUUID().keySet()) {
            if (name.toLowerCase(Locale.ROOT).startsWith(lowerIn)) {
                names.add(name);
            }
            if (names.size() != 4) continue;
            break;
        }
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        for (String name : names) {
            UUID uuid = data.getNameToUUID().get(name);
            if (data.isMailboxFull(uuid)) {
                ticks.add(-1);
                continue;
            }
            GlobalPos mailboxPos = data.getMailboxPos(uuid);
            if (!(player.f_36096_ instanceof PostboxScreenHandler)) continue;
            int tick = 0;
            if (!((PostboxScreenHandler)player.f_36096_).isEnderMail()) {
                tick = mailboxPos != null ? MailboxManager.getDeliveryTicks((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20183_(), (ResourceKey<Level>)mailboxPos.m_122640_(), mailboxPos.m_122646_()) : (ContactCommonConfig.isEnableCenterMailbox() ? MailboxManager.getDeliveryTicks((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20183_(), (ResourceKey<Level>)Level.f_46428_, player.m_9236_().m_220360_()) : -2);
            }
            ticks.add(tick);
        }
        if (player.f_36096_ instanceof PostboxScreenHandler) {
            if (this.shouldSend && !names.isEmpty() && Objects.equals(names.get(0), this.nameIn) && (Integer)ticks.get(0) >= 0) {
                this.handleSendMail(player, data, (String)names.get(0), (Integer)ticks.get(0));
            } else {
                AddresseeDataMessage.create(names, ticks).sendTo(player);
            }
        }
    }

    private void handleSendMail(ServerPlayer player, IMailboxDataProvider data, String recipientName, int deliveryTicks) {
        UUID uuid;
        GlobalPos mailboxPos;
        PostboxScreenHandler container = (PostboxScreenHandler)player.f_36096_;
        ItemStack parcel = container.parcel.m_8020_(0);
        parcel.m_41784_().m_128359_("Sender", player.m_7755_().getString());
        if (IPackageItem.checkAndPostmarkPostcard(parcel, player.m_7755_().getString()) || parcel.m_41720_() instanceof PostcardItem) {
            AdvancementManager.givePlayerAdvancement(player.f_8924_, player, new ResourceLocation("contact:send_postcard"));
        }
        if ((mailboxPos = data.getMailboxPos(uuid = data.getNameToUUID().get(recipientName))) != null) {
            if (mailboxPos.m_122640_() != player.m_9236_().m_46472_()) {
                parcel.m_41784_().m_128379_("AnotherWorld", true);
            }
        } else if (Level.f_46428_ != player.m_9236_().m_46472_()) {
            parcel.m_41784_().m_128379_("AnotherWorld", true);
        }
        data.getMailList().add(new MailToBeSent(uuid, parcel, deliveryTicks));
        ActionMessage.create(1).sendTo(player);
        container.parcel.m_6836_(0, ItemStack.f_41583_);
    }

    public static EnquireAddresseeMessage create(String name, boolean shouldSend) {
        return new EnquireAddresseeMessage(name, shouldSend);
    }

    public void sendToServer() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static void registerC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ID, (buf, ctx) -> {
            EnquireAddresseeMessage msg = EnquireAddresseeMessage.decode(buf);
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            if (player != null) {
                player.f_8924_.execute(() -> msg.handleServer(player));
            }
        });
    }
}

