/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.item.PostcardItem;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class PostcardEditMessage {
    private static final ResourceLocation ID = new ResourceLocation("contact", "postcard_edit");
    private final ItemStack postcard;
    private final int held;

    public PostcardEditMessage(ItemStack postcard, int held) {
        this.postcard = postcard;
        this.held = held;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.postcard);
        buf.writeInt(this.held);
    }

    public static PostcardEditMessage decode(FriendlyByteBuf buf) {
        ItemStack postcard = buf.m_130267_();
        int held = buf.readInt();
        return new PostcardEditMessage(postcard, held);
    }

    public void handleServer(ServerPlayer player) {
        ItemStack card;
        if (player == null) {
            return;
        }
        if (this.postcard.m_41720_() instanceof PostcardItem && this.postcard.m_41782_() && (Inventory.m_36045_((int)this.held) || this.held == 40) && (card = player.m_150109_().m_8020_(this.held)).m_41720_() instanceof PostcardItem) {
            card.m_41751_(this.postcard.m_41783_());
        }
    }

    public static PostcardEditMessage create(ItemStack postcard, int held) {
        return new PostcardEditMessage(postcard, held);
    }

    public void sendToServer() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static void registerC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ID, (buf, ctx) -> {
            PostcardEditMessage msg = PostcardEditMessage.decode(buf);
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            if (player != null) {
                player.f_8924_.execute(() -> msg.handleServer(player));
            }
        });
    }
}

