/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class TextBoxEditMessage {
    private static final ResourceLocation ID = new ResourceLocation("contact", "textbox_edit");
    private final ItemStack item;
    private final int held;

    public TextBoxEditMessage(ItemStack item, int held) {
        this.item = item;
        this.held = held;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.item);
        buf.writeInt(this.held);
    }

    public static TextBoxEditMessage decode(FriendlyByteBuf buf) {
        ItemStack item = buf.m_130267_();
        int held = buf.readInt();
        return new TextBoxEditMessage(item, held);
    }

    public void handleServer(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (this.item.m_41782_() && (Inventory.m_36045_((int)this.held) || this.held == 40)) {
            ItemStack card = player.m_150109_().m_8020_(this.held);
            card.m_41751_(this.item.m_41783_());
        }
    }

    public static TextBoxEditMessage create(ItemStack item, int held) {
        return new TextBoxEditMessage(item, held);
    }

    public void sendToServer() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static void registerC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ID, (buf, ctx) -> {
            TextBoxEditMessage msg = TextBoxEditMessage.decode(buf);
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            if (player != null) {
                player.f_8924_.execute(() -> msg.handleServer(player));
            }
        });
    }
}

