/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.resourse;

import com.flechazo.contact.resourse.PostcardDataManager;
import com.mafuyu404.oelib.api.data.DataDriven;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@DataDriven(modid="contact", folder="postcards", syncToClient=true, enableCache=true, priority=100)
public record PostcardStyle(PostcardInfo postcard, TradeInfo trade, TextInfo text, PostmarkInfo postmark) {
    public static final Codec<PostcardStyle> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PostcardInfo.CODEC.fieldOf("postcard").forGetter(PostcardStyle::postcard), (App)TradeInfo.CODEC.fieldOf("trade").forGetter(PostcardStyle::trade), (App)TextInfo.CODEC.fieldOf("text").forGetter(PostcardStyle::text), (App)PostmarkInfo.CODEC.fieldOf("postmark").forGetter(PostcardStyle::postmark)).apply((Applicative)instance, PostcardStyle::new));
    public static final PostcardStyle DEFAULT = new PostcardStyle(new PostcardInfo("contact:stripes", 200, 133), new TradeInfo(true, new ItemStack((ItemLike)Items.f_42616_)), new TextInfo(10, 12, 180, 96, new ColorInfo(255, 183, 111, 64)), new PostmarkInfo("contact:postmark", 142, -5, 64, 52, new ColorInfo(120, 182, 153, 104)));

    public String cardTexture() {
        return this.postcard.texture();
    }

    public int cardWidth() {
        return this.postcard.width();
    }

    public int cardHeight() {
        return this.postcard.height();
    }

    public ItemStack cardPrice() {
        return this.trade.price();
    }

    public boolean soldByTrader() {
        return this.trade.soldByTrader();
    }

    public int textPosX() {
        return this.text.x();
    }

    public int textPosY() {
        return this.text.y();
    }

    public int textWidth() {
        return this.text.width();
    }

    public int textHeight() {
        return this.text.height();
    }

    public int textColor() {
        return this.text.color().toARGB();
    }

    public String postmarkTexture() {
        return this.postmark.texture();
    }

    public int postmarkPosX() {
        return this.postmark.x();
    }

    public int postmarkPosY() {
        return this.postmark.y();
    }

    public int postmarkWidth() {
        return this.postmark.width();
    }

    public int postmarkHeight() {
        return this.postmark.height();
    }

    public int postmarkColor() {
        return this.postmark.color().toARGB();
    }

    public ResourceLocation getCardTexture() {
        ResourceLocation origin = new ResourceLocation(this.postcard.texture());
        return new ResourceLocation(origin.m_135827_(), "textures/postcard/" + origin.m_135815_() + ".png");
    }

    public ResourceLocation getPostmarkTexture() {
        ResourceLocation origin = new ResourceLocation(this.postmark.texture());
        return new ResourceLocation(origin.m_135827_(), "textures/postcard/" + origin.m_135815_() + ".png");
    }

    public static PostcardStyle fromNBT(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag info = tag.m_128469_("Info");
            String id = "contact:" + info.m_128461_("ID");
            int posX = info.m_128451_("PosX");
            int posY = info.m_128451_("PosY");
            int textWidth = info.m_128451_("Width");
            int textHeight = info.m_128451_("Height");
            int color = info.m_128451_("Color");
            return new PostcardStyle(new PostcardInfo(id, 200, 133), new TradeInfo(true, new ItemStack((ItemLike)Items.f_42616_)), new TextInfo(posX, posY, textWidth, textHeight, new ColorInfo(color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF)), new PostmarkInfo("contact:postmark", 142, -5, 64, 52, new ColorInfo(color >> 24 & 0xCD, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF)));
        }
        if (tag.m_128441_("CardID")) {
            ResourceLocation cardID = new ResourceLocation(tag.m_128461_("CardID"));
            return PostcardDataManager.getPostcards().getOrDefault(cardID, DEFAULT);
        }
        return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElse(DEFAULT);
    }

    public record PostcardInfo(String texture, int width, int height) {
        public static final Codec<PostcardInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("texture").forGetter(PostcardInfo::texture), (App)Codec.INT.fieldOf("width").forGetter(PostcardInfo::width), (App)Codec.INT.fieldOf("height").forGetter(PostcardInfo::height)).apply((Applicative)instance, PostcardInfo::new));
    }

    public record TradeInfo(boolean soldByTrader, ItemStack price) {
        public static final Codec<TradeInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("soldByTrader", (Object)true).forGetter(TradeInfo::soldByTrader), (App)ItemStack.f_41582_.fieldOf("price").forGetter(TradeInfo::price)).apply((Applicative)instance, TradeInfo::new));
    }

    public record TextInfo(int x, int y, int width, int height, ColorInfo color) {
        public static final Codec<TextInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(TextInfo::x), (App)Codec.INT.fieldOf("y").forGetter(TextInfo::y), (App)Codec.INT.fieldOf("width").forGetter(TextInfo::width), (App)Codec.INT.fieldOf("height").forGetter(TextInfo::height), (App)ColorInfo.CODEC.fieldOf("color").forGetter(TextInfo::color)).apply((Applicative)instance, TextInfo::new));
    }

    public record PostmarkInfo(String texture, int x, int y, int width, int height, ColorInfo color) {
        public static final Codec<PostmarkInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("texture").forGetter(PostmarkInfo::texture), (App)Codec.INT.fieldOf("x").forGetter(PostmarkInfo::x), (App)Codec.INT.fieldOf("y").forGetter(PostmarkInfo::y), (App)Codec.INT.fieldOf("width").forGetter(PostmarkInfo::width), (App)Codec.INT.fieldOf("height").forGetter(PostmarkInfo::height), (App)ColorInfo.CODEC.fieldOf("color").forGetter(PostmarkInfo::color)).apply((Applicative)instance, PostmarkInfo::new));
    }

    public record ColorInfo(int alpha, int red, int green, int blue) {
        public static final Codec<ColorInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("alpha").forGetter(ColorInfo::alpha), (App)Codec.INT.fieldOf("red").forGetter(ColorInfo::red), (App)Codec.INT.fieldOf("green").forGetter(ColorInfo::green), (App)Codec.INT.fieldOf("blue").forGetter(ColorInfo::blue)).apply((Applicative)instance, ColorInfo::new));

        public int toARGB() {
            return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
        }
    }
}

