/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalplayer.item.custom;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.utils.AudioUtils;
import de.maxhenkel.audioplayer.voicechat.VoicechatAudioPlayerPlugin;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.dented.personalplayer.component.ModDataComponentTypes;
import net.dented.personalplayer.component.PersonalPlayerContentsComponent;
import net.dented.personalplayer.component.PersonalPlayerTooltipData;
import net.dented.personalplayer.component.PersonalPlayerUuidComponent;
import net.dented.personalplayer.network.AudioPlayerStopC2SPacket;
import net.dented.personalplayer.network.PersonalPlayerPlayS2CPacket;
import net.dented.personalplayer.network.PersonalPlayerStopS2CPacket;
import net.dented.personalplayer.sound.PersonalDiscPlayerSoundInstance;
import net.dented.personalplayer.util.ObjectManager;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.class_9792;
import net.minecraft.class_9793;

public class APPersonalDiscPlayerItem
extends class_1792 {
    public APPersonalDiscPlayerItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        class_1799 slotStack = slot.method_7677();
        if (clickType == class_5536.field_27013 && !slotStack.method_7960()) {
            if (this.insertDisc(stack, slotStack, player)) {
                this.onContentChanged(player);
                return true;
            }
        } else if (clickType == class_5536.field_27014 && slotStack.method_7960()) {
            if (this.removeDisc(stack, player, arg_0 -> ((class_1735)slot).method_53512(arg_0))) {
                this.onContentChanged(player);
                return true;
            }
        }
        return false;
    }

    public boolean method_31566(class_1799 stack, class_1799 cursorStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorRef) {
        if (clickType == class_5536.field_27013 && !cursorStack.method_7960()) {
            if (this.insertDisc(stack, cursorStack, player)) {
                this.onContentChanged(player);
                return true;
            }
        } else if (clickType == class_5536.field_27014 && cursorStack.method_7960()) {
            if (this.removeDisc(stack, player, arg_0 -> ((class_5630)cursorRef).method_32332(arg_0))) {
                this.onContentChanged(player);
                return true;
            }
        }
        return false;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_1799 itemStack = hand == class_1268.field_5810 ? serverPlayer.method_6079() : serverPlayer.method_6047();
                PersonalPlayerContentsComponent contents = (PersonalPlayerContentsComponent)itemStack.method_58694(ModDataComponentTypes.PERSONAL_PLAYER_CONTENTS);
                if (contents != PersonalPlayerContentsComponent.DEFAULT) {
                    UUID uuid = contents.getUuid();
                    class_1799 discStack = contents.getItemStack();
                    if (FabricLoader.getInstance().isModLoaded("audioplayer")) {
                        AudioData customSound = AudioData.of((class_1799)discStack);
                        if (customSound != null) {
                            this.handleAudioPlayer(world, serverPlayer, customSound, uuid, user.method_5715());
                        } else {
                            this.playJukeboxSong(serverWorld, serverPlayer, discStack, uuid, user.method_5715());
                        }
                    } else {
                        this.playJukeboxSong(serverWorld, serverPlayer, discStack, uuid, user.method_5715());
                    }
                }
            }
        }
        return super.method_7836(world, user, hand);
    }

    private boolean insertDisc(class_1799 playerItem, class_1799 source, class_1657 player) {
        if (source.method_7960() || source.method_58694(class_9334.field_52175) == null) {
            return false;
        }
        PersonalPlayerContentsComponent contents = (PersonalPlayerContentsComponent)playerItem.method_58694(ModDataComponentTypes.PERSONAL_PLAYER_CONTENTS);
        if (contents != PersonalPlayerContentsComponent.DEFAULT) {
            APPersonalDiscPlayerItem.playInsertFailSound((class_1297)player);
            return false;
        }
        UUID uuid = playerItem.method_58694(ModDataComponentTypes.PERSONAL_PLAYER_UUID) == PersonalPlayerUuidComponent.DEFAULT ? UUID.randomUUID() : ((PersonalPlayerUuidComponent)playerItem.method_58694(ModDataComponentTypes.PERSONAL_PLAYER_UUID)).uuid();
        playerItem.method_57379(ModDataComponentTypes.PERSONAL_PLAYER_UUID, (Object)new PersonalPlayerUuidComponent(uuid));
        playerItem.method_57379(ModDataComponentTypes.PERSONAL_PLAYER_CONTENTS, (Object)new PersonalPlayerContentsComponent(source.method_46651(1), uuid));
        if (!player.method_73183().method_8608()) {
            source.method_7934(1);
        }
        APPersonalDiscPlayerItem.playInsertSound((class_1297)player);
        return true;
    }

    private boolean removeDisc(class_1799 playerItem, class_1657 player, Consumer<class_1799> output) {
        Object object;
        PersonalPlayerContentsComponent contents = (PersonalPlayerContentsComponent)playerItem.method_58694(ModDataComponentTypes.PERSONAL_PLAYER_CONTENTS);
        if (contents == PersonalPlayerContentsComponent.DEFAULT) {
            return false;
        }
        class_1799 disc = contents.getItemStack();
        UUID uuid = contents.getUuid();
        playerItem.method_57379(ModDataComponentTypes.PERSONAL_PLAYER_CONTENTS, (Object)PersonalPlayerContentsComponent.DEFAULT);
        if (FabricLoader.getInstance().isModLoaded("audioplayer") && player.method_73183().method_8608()) {
            ClientPlayNetworking.send((class_8710)new AudioPlayerStopC2SPacket(uuid));
        }
        if (player.method_73183().method_8608() && (object = ObjectManager.getSoundInstance(uuid)) instanceof PersonalDiscPlayerSoundInstance) {
            PersonalDiscPlayerSoundInstance instance = (PersonalDiscPlayerSoundInstance)((Object)object);
            PersonalDiscPlayerSoundInstance.cancel(instance);
            ObjectManager.removeSoundInstance(uuid);
        }
        APPersonalDiscPlayerItem.playRemoveOneSound((class_1297)player);
        output.accept(disc);
        return true;
    }

    private void handleAudioPlayer(class_1937 world, class_3222 serverPlayer, AudioData customSound, UUID uuid, boolean isSneaking) {
        try {
            VoicechatServerApi api = VoicechatAudioPlayerPlugin.voicechatServerApi;
            VoicechatConnection connection = api.getConnectionOf(serverPlayer.method_5667());
            if (connection == null) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"You need to enable voice chat to hear custom audio"), true);
                return;
            }
            short[] audio = AudioUtils.convert((Path)AudioStorageManager.instance().getExistingSoundFile(customSound.getSoundId()));
            if (((Float)AudioPlayerMod.SERVER_CONFIG.maxMusicDiscDuration.get()).floatValue() > -1.0f && AudioUtils.getLengthSeconds((short[])audio) > ((Float)AudioPlayerMod.SERVER_CONFIG.maxMusicDiscDuration.get()).floatValue()) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"Audio is too long to play").method_27692(class_124.field_1079), true);
                return;
            }
            AudioPlayer audioPlayer = (AudioPlayer)ObjectManager.getAudioPlayer(uuid);
            if (audioPlayer != null) {
                if (isSneaking) {
                    audioPlayer.stopPlaying();
                    ObjectManager.removeAudioPlayer(uuid);
                    return;
                }
                audioPlayer.startPlaying();
                return;
            }
            StaticAudioChannel audioChannel = api.createStaticAudioChannel(uuid, connection.getPlayer().getServerLevel(), connection);
            audioPlayer = api.createAudioPlayer((AudioChannel)audioChannel, api.createEncoder(), audio);
            ObjectManager.addAudioPlayer(uuid, audioPlayer);
            audioPlayer.startPlaying();
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.error("Failed to play audio", (Throwable)e);
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"Failed to play audio: %s".formatted(e.getMessage())).method_27692(class_124.field_1079), true);
        }
    }

    private void playJukeboxSong(class_3218 serverWorld, class_3222 serverPlayer, class_1799 disc, UUID uuid, boolean sneaking) {
        class_9792 playable = (class_9792)disc.method_58694(class_9334.field_52175);
        if (playable == null) {
            return;
        }
        Optional song = playable.comp_2833().method_60740(serverWorld.method_30349().method_30530(class_7924.field_52176));
        if (sneaking) {
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new PersonalPlayerStopS2CPacket(uuid));
        } else {
            song.ifPresent(jukeboxSong -> ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new PersonalPlayerPlayS2CPacket((class_9793)jukeboxSong, uuid)));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.ofNullable((PersonalPlayerContentsComponent)stack.method_58694(ModDataComponentTypes.PERSONAL_PLAYER_CONTENTS)).map(PersonalPlayerTooltipData::new);
    }

    private static void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }

    public static void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }

    public static void playInsertFailSound(class_1297 entity) {
        entity.method_5783(class_3417.field_52372, 1.0f, 1.0f);
    }

    private void onContentChanged(class_1657 user) {
        class_1703 screenHandler = user.field_7512;
        if (screenHandler != null) {
            screenHandler.method_7609((class_1263)user.method_31548());
        }
    }
}

