/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_coldsweat;

import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.BlockTempRegisterEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.CaveBiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.atobaazul.tfc_coldsweat.CompatManager;
import net.atobaazul.tfc_coldsweat.block_temp.BlastFurnaceBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.BloomeryBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.BottomOvenBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.CastIronGrillBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.CharcoalForgeBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.CrucibleBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.FirepitBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.FluidLoggableTemp;
import net.atobaazul.tfc_coldsweat.block_temp.GrillBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.InsulatedBottomOvenBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.PotBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.SeaIceBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.SpringWaterBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.TFCCandleBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.TFCLampBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.TFCMagmaBlockTemp;
import net.atobaazul.tfc_coldsweat.block_temp.TFCTorchBlockTemp;
import net.atobaazul.tfc_coldsweat.inv_temp.HotItemsTempModifier;
import net.atobaazul.tfc_coldsweat.modifier.ClimateTempModifier;
import net.atobaazul.tfc_coldsweat.modifier.SunlightTempModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventListener {
    public static final TempModifier TFCSeasonModifier = new ClimateTempModifier();
    public static final TempModifier TFCSunlightModifier = new SunlightTempModifier();

    private static double getSeasonalGraceDuration(Level level, Player player) {
        double tempAtSpawn;
        int baseDuration = (Integer)ConfigSettings.GRACE_LENGTH.get();
        double baseTemp = Temperature.convert((double)27.0, (Temperature.Units)Temperature.Units.C, (Temperature.Units)Temperature.Units.MC, (boolean)true);
        double tempPercent = baseTemp / (tempAtSpawn = WorldHelper.getTemperatureAt((Level)level, (BlockPos)player.m_20183_()));
        if (tempPercent < 1.0) {
            tempPercent = 1.0 + (1.0 - tempPercent);
        }
        tempPercent = Math.min(tempPercent, 2.0);
        return (double)baseDuration * tempPercent;
    }

    @SubscribeEvent
    public static void onSpawn(EntityJoinLevelEvent event) {
        if (!event.getLevel().f_46443_ && event.getEntity() instanceof Player && ((Boolean)ConfigSettings.GRACE_ENABLED.get()).booleanValue() && !event.getEntity().getPersistentData().m_128471_("GivenGracePeriod")) {
            event.getEntity().getPersistentData().m_128379_("GivenGracePeriod", true);
            ((Player)event.getEntity()).m_7292_(new MobEffectInstance(ModEffects.GRACE, (int)EventListener.getSeasonalGraceDuration(event.getLevel(), (Player)event.getEntity()), 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void defineDefaultModifiers(DefaultTempModifiersEvent event) {
        if (event.getEntity() instanceof Player && CompatManager.TFC_ENABLED != null) {
            event.addModifier(Temperature.Trait.WORLD, TFCSeasonModifier, Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new HotItemsTempModifier(), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.getModifiers(Temperature.Trait.WORLD).removeIf(modifier -> modifier instanceof BiomeTempModifier || modifier instanceof CaveBiomeTempModifier || modifier instanceof ElevationTempModifier);
        }
    }

    @SubscribeEvent
    public static void registerTempModifiers(TempModifierRegisterEvent event) {
        if (CompatManager.TFC_ENABLED != null) {
            event.register(new ResourceLocation("tfc_coldsweat", "season"), ClimateTempModifier::new);
            event.register(new ResourceLocation("tfc_coldsweat", "hot_items"), HotItemsTempModifier::new);
        }
    }

    @SubscribeEvent
    public static void registerBlockTemps(BlockTempRegisterEvent event) {
        if (CompatManager.TFC_ENABLED != null) {
            event.register((BlockTemp)new BlastFurnaceBlockTemp());
            event.register((BlockTemp)new BloomeryBlockTemp());
            event.register((BlockTemp)new CharcoalForgeBlockTemp());
            event.register((BlockTemp)new FirepitBlockTemp());
            event.register((BlockTemp)new GrillBlockTemp());
            event.register((BlockTemp)new PotBlockTemp());
            event.register((BlockTemp)new SpringWaterBlockTemp());
            event.register((BlockTemp)new TFCTorchBlockTemp());
            event.register((BlockTemp)new TFCMagmaBlockTemp());
            event.register((BlockTemp)new SeaIceBlockTemp());
            event.register((BlockTemp)new CrucibleBlockTemp());
            event.register((BlockTemp)new TFCCandleBlockTemp());
            event.register((BlockTemp)new TFCLampBlockTemp());
            event.register((BlockTemp)new FluidLoggableTemp());
        }
        if (CompatManager.FIRMALIFE_ENABLED != null) {
            event.register((BlockTemp)new BottomOvenBlockTemp());
            event.register((BlockTemp)new InsulatedBottomOvenBlockTemp());
        }
        if (CompatManager.CASTIRONGRILL_ENABLED != null) {
            event.register((BlockTemp)new CastIronGrillBlockTemp());
        }
    }
}

