/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_coldsweat.registries;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class TFCColdSweatRegistrationHelpers {
    public static <T extends Block> RegistryObject<T> registerBlock(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        String actualName = name.toLowerCase(Locale.ROOT);
        RegistryObject block = blocks.register(actualName, blockSupplier);
        if (blockItemFactory != null) {
            items.register(actualName, () -> (BlockItem)blockItemFactory.apply((Block)block.get()));
        }
        return block;
    }

    public static <F extends FlowingFluid> FluidRegistryObject<F> registerFluid(DeferredRegister<FluidType> fluidTypes, DeferredRegister<Fluid> fluids, String typeName, String sourceName, String flowingName, Consumer<ForgeFlowingFluid.Properties> builder, Supplier<FluidType> typeFactory, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        MutableObject typeBox = new MutableObject();
        RegistryObject source = fluids.register(sourceName, () -> TFCColdSweatRegistrationHelpers.lambda$registerFluid$1(sourceFactory, (Mutable)typeBox));
        RegistryObject flowing = fluids.register(flowingName, () -> TFCColdSweatRegistrationHelpers.lambda$registerFluid$2(flowingFactory, (Mutable)typeBox));
        RegistryObject fluidType = fluidTypes.register(typeName, typeFactory);
        typeBox.setValue((Object)Lazy.of(() -> {
            ForgeFlowingFluid.Properties lazyProperties = new ForgeFlowingFluid.Properties((Supplier)fluidType, (Supplier)source, (Supplier)flowing);
            builder.accept(lazyProperties);
            return lazyProperties;
        }));
        return new FluidRegistryObject(fluidType, flowing, source);
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> block) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Stream<? extends Supplier<? extends Block>> blocks) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])blocks.map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
    }

    public static <T extends InventoryBlockEntity<?>, C extends BlockEntityContainer<T>> RegistryObject<MenuType<C>> registerBlockEntityContainer(DeferredRegister<MenuType<?>> containers, String name, Supplier<BlockEntityType<T>> type, BlockEntityContainer.Factory<T, C> factory) {
        return TFCColdSweatRegistrationHelpers.registerContainer(containers, name, (windowId, playerInventory, buffer) -> {
            Level level = playerInventory.f_35978_.m_9236_();
            BlockPos pos = buffer.m_130135_();
            InventoryBlockEntity entity = (InventoryBlockEntity)level.m_141902_(pos, (BlockEntityType)type.get()).orElseThrow();
            return factory.create(entity, playerInventory, windowId);
        });
    }

    public static <C extends ItemStackContainer> RegistryObject<MenuType<C>> registerItemStackContainer(DeferredRegister<MenuType<?>> containers, String name, ItemStackContainer.Factory<C> factory) {
        return TFCColdSweatRegistrationHelpers.registerContainer(containers, name, (windowId, playerInventory, buffer) -> {
            ItemStackContainerProvider.Info info = ItemStackContainerProvider.read((FriendlyByteBuf)buffer, (Inventory)playerInventory);
            return factory.create(info.stack(), info.hand(), info.slot(), playerInventory, windowId);
        });
    }

    public static <C extends AbstractContainerMenu> RegistryObject<MenuType<C>> registerContainer(DeferredRegister<MenuType<?>> containers, String name, IContainerFactory<C> factory) {
        return containers.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
    }

    private static /* synthetic */ FlowingFluid lambda$registerFluid$2(Function flowingFactory, Mutable typeBox) {
        return (FlowingFluid)flowingFactory.apply((ForgeFlowingFluid.Properties)((Lazy)typeBox.getValue()).get());
    }

    private static /* synthetic */ FlowingFluid lambda$registerFluid$1(Function sourceFactory, Mutable typeBox) {
        return (FlowingFluid)sourceFactory.apply((ForgeFlowingFluid.Properties)((Lazy)typeBox.getValue()).get());
    }
}

