/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_coldsweat.events;

import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.BlockTempRegisterEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.CaveBiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.atobaazul.tfc_coldsweat.CompatManager;
import net.atobaazul.tfc_coldsweat.temperature.block.BloomeryBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.CharcoalForgeBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.FluidLoggableBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.IHeatableBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.SeaIceBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.SpringWaterBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.TFCCandleBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.TFCLampBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.TFCMagmaBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.block.TFCTorchBlockTemp;
import net.atobaazul.tfc_coldsweat.temperature.modifier.ClimateTempModifier;
import net.atobaazul.tfc_coldsweat.temperature.modifier.ItemHeatTempModifier;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

@EventBusSubscriber
public class Events {
    public static final TempModifier TFCSeasonModifier = new ClimateTempModifier();
    public static final TempModifier ItemTempModifier = new ItemHeatTempModifier();

    private static double getSeasonalGraceDuration(Level level, Player player) {
        double tempAtSpawn;
        int baseDuration = (Integer)ConfigSettings.GRACE_LENGTH.get();
        double baseTemp = Temperature.convert((double)27.0, (Temperature.Units)Temperature.Units.C, (Temperature.Units)Temperature.Units.MC, (boolean)true);
        double tempPercent = baseTemp / (tempAtSpawn = WorldHelper.getTemperatureAt((Level)level, (BlockPos)player.blockPosition()));
        if (tempPercent < 1.0) {
            tempPercent = 1.0 + (1.0 - tempPercent);
        }
        tempPercent = Math.min(tempPercent, 2.0);
        return (double)baseDuration * tempPercent;
    }

    @SubscribeEvent
    public static void onSpawn(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide && event.getEntity() instanceof Player && ((Boolean)ConfigSettings.GRACE_ENABLED.get()).booleanValue() && !event.getEntity().getPersistentData().getBoolean("GivenGracePeriod")) {
            event.getEntity().getPersistentData().putBoolean("GivenGracePeriod", true);
            ((Player)event.getEntity()).addEffect(new MobEffectInstance((Holder)ModEffects.GRACE, (int)Events.getSeasonalGraceDuration(event.getLevel(), (Player)event.getEntity()), 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void onUseItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getItem().is((Holder)ModItems.FILLED_WATERSKIN)) {
                IPlayerInfo.get((Player)player).addThirst(20.0f);
            }
        }
    }

    @SubscribeEvent
    public static void defineDefaultModifiers(DefaultTempModifiersEvent event) {
        if (event.getEntity() instanceof Player && CompatManager.TFC_ENABLED != null) {
            event.addModifier(Temperature.Trait.WORLD, TFCSeasonModifier, Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier(Temperature.Trait.WORLD, ItemTempModifier, Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.getModifiers(Temperature.Trait.WORLD).removeIf(modifier -> modifier instanceof BiomeTempModifier || modifier instanceof CaveBiomeTempModifier || modifier instanceof ElevationTempModifier);
        }
    }

    @SubscribeEvent
    public static void registerTempModifiers(TempModifierRegisterEvent event) {
        if (CompatManager.TFC_ENABLED != null) {
            event.register(ResourceLocation.fromNamespaceAndPath((String)"tfc_coldsweat", (String)"season"), ClimateTempModifier::new);
            event.register(ResourceLocation.fromNamespaceAndPath((String)"tfc_coldsweat", (String)"hot_items"), ItemHeatTempModifier::new);
        }
    }

    @SubscribeEvent
    public static void registerBlockTemps(BlockTempRegisterEvent event) {
        if (CompatManager.TFC_ENABLED != null) {
            event.register((BlockTemp)new BloomeryBlockTemp());
            event.register((BlockTemp)new CharcoalForgeBlockTemp());
            event.register((BlockTemp)new SpringWaterBlockTemp());
            event.register((BlockTemp)new TFCTorchBlockTemp());
            event.register((BlockTemp)new TFCMagmaBlockTemp());
            event.register((BlockTemp)new SeaIceBlockTemp());
            event.register((BlockTemp)new TFCCandleBlockTemp());
            event.register((BlockTemp)new TFCLampBlockTemp());
            event.register((BlockTemp)new FluidLoggableBlockTemp());
            event.register((BlockTemp)new IHeatableBlockTemp());
        }
    }
}

