/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.base;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.base.PowderUtil;
import com.gertoxq.wynnbuild.base.bitcodemaps.BaseEncoding;
import com.gertoxq.wynnbuild.base.custom.CustomCoder;
import com.gertoxq.wynnbuild.base.util.BitVector;
import com.gertoxq.wynnbuild.base.util.EncodingBitVector;
import com.gertoxq.wynnbuild.build.AtreeCoder;
import com.gertoxq.wynnbuild.build.Build;
import com.gertoxq.wynnbuild.screens.aspect.AspectInfo;
import com.gertoxq.wynnbuild.util.Utils;
import com.gertoxq.wynnbuild.util.WynnData;
import com.wynntils.core.components.Models;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodeDecode {
    public static final Map<Integer, Integer> POWDERABLES = Map.of(0, 0, 1, 1, 2, 2, 3, 3, 8, 4);
    public static final List<GearType> EQUIPMENT_ORDER = List.of(GearType.HELMET, GearType.CHESTPLATE, GearType.LEGGINGS, GearType.BOOTS, GearType.RING, GearType.RING, GearType.BRACELET, GearType.NECKLACE);
    public static final BaseEncoding ENC = new BaseEncoding();
    static final byte VECTOR_FLAG = 12;
    static final int VERSION_BITLEN = 10;
    static final int CUSTOM_STR_LENGTH_BITLEN = 12;

    public static EncodingBitVector encodeHeader(int wynnVersionId) {
        EncodingBitVector headerVec = new EncodingBitVector(0L, 0);
        headerVec.append(12L, 6);
        headerVec.append(wynnVersionId, 10);
        return headerVec;
    }

    public static Map<Powder, Integer> collectPowders(List<Powder> powders) {
        HashMap<Powder, Integer> countingMap = new HashMap<Powder, Integer>();
        for (Powder powder : powders) {
            countingMap.putIfAbsent(powder, 1);
            countingMap.put(powder, (Integer)countingMap.get(powder) + 1);
        }
        return countingMap;
    }

    public static EncodingBitVector encodePowders(List<Powder> powders) {
        EncodingBitVector powderVec = new EncodingBitVector(0L, 0);
        if (powders.isEmpty()) {
            powderVec.appendFlag(ENC.EQUIPMENT_POWDERS_FLAG(), EncodeDecode.ENC.EQUIPMENT_POWDERS_FLAG().NO_POWDERS);
            return powderVec;
        }
        Map<Powder, Integer> collectedPowders = EncodeDecode.collectPowders(powders);
        powderVec.appendFlag(ENC.EQUIPMENT_POWDERS_FLAG(), EncodeDecode.ENC.EQUIPMENT_POWDERS_FLAG().HAS_POWDERS);
        AtomicReference<Integer> previousPowder = new AtomicReference<Integer>(-1);
        collectedPowders.forEach((powder, amount) -> {
            int powderId = PowderUtil.getId(powder, WynnBuild.getConfig().getDefaultPowderLevel());
            if ((Integer)previousPowder.get() != -1) {
                powderVec.appendFlag(ENC.POWDER_REPEAT_OP(), EncodeDecode.ENC.POWDER_REPEAT_OP().NO_REPEAT);
                if (powderId % 6 == (Integer)previousPowder.get() % 6) {
                    powderVec.appendFlag(ENC.POWDER_REPEAT_TIER_OP(), EncodeDecode.ENC.POWDER_REPEAT_TIER_OP().REPEAT_TIER);
                    int elementAmount = ENC.POWDER_ELEMENTS().size();
                    int elementWrapper = Utils.mod(PowderUtil.getPowder(powderId).getElement().ordinal() - PowderUtil.getPowder((Integer)previousPowder.get()).getElement().ordinal(), elementAmount) - 1;
                    powderVec.append(elementWrapper, ENC.POWDER_WRAPPER_BITLEN());
                } else {
                    powderVec.appendFlag(ENC.POWDER_REPEAT_TIER_OP(), EncodeDecode.ENC.POWDER_REPEAT_TIER_OP().CHANGE_POWDER);
                    powderVec.appendFlag(ENC.POWDER_CHANGE_OP(), EncodeDecode.ENC.POWDER_CHANGE_OP().NEW_POWDER);
                    powderVec.append(powderId, ENC.POWDER_ID_BITLEN());
                }
            } else {
                powderVec.append(powderId, ENC.POWDER_ID_BITLEN());
            }
            for (int i = 1; i < amount - 1; ++i) {
                powderVec.appendFlag(ENC.POWDER_REPEAT_OP(), EncodeDecode.ENC.POWDER_REPEAT_OP().REPEAT);
            }
            previousPowder.set(powderId);
        });
        powderVec.appendFlag(ENC.POWDER_REPEAT_OP(), EncodeDecode.ENC.POWDER_REPEAT_OP().NO_REPEAT);
        powderVec.appendFlag(ENC.POWDER_REPEAT_TIER_OP(), EncodeDecode.ENC.POWDER_REPEAT_TIER_OP().CHANGE_POWDER);
        powderVec.appendFlag(ENC.POWDER_CHANGE_OP(), EncodeDecode.ENC.POWDER_CHANGE_OP().NEW_ITEM);
        return powderVec;
    }

    public static EncodingBitVector encodeEquipment(List<class_1799> equipment, List<List<Powder>> powders, boolean precise) {
        EncodingBitVector equipmentVec = new EncodingBitVector(0L, 0);
        for (int idx = 0; idx < equipment.size(); ++idx) {
            Optional gearOpt = Models.Item.asWynnItem(equipment.get(idx), GearItem.class);
            GearItem gear = gearOpt.orElse(null);
            Optional craftedOpt = Models.Item.asWynnItem(equipment.get(idx), CraftedGearItem.class);
            CraftedGearItem crafted = craftedOpt.orElse(null);
            int equipmentKind = gearOpt.isPresent() && ((GearItem)gearOpt.get()).getItemInfo().metaInfo().preIdentified() ? EncodeDecode.ENC.EQUIPMENT_KIND().NORMAL : (craftedOpt.isPresent() || gearOpt.isPresent() && precise ? EncodeDecode.ENC.EQUIPMENT_KIND().CUSTOM : EncodeDecode.ENC.EQUIPMENT_KIND().NORMAL);
            equipmentVec.append(equipmentKind, ENC.EQUIPMENT_KIND().BITLEN());
            switch (equipmentKind) {
                case 0: {
                    Integer id = 0;
                    if (gear != null) {
                        id = WynnData.getIdMap().get(gear.getName());
                        if (id == null) {
                            WynnBuild.warn("Unknown item: {}", gear.getName());
                            id = 0;
                        } else {
                            Integer n = id;
                            id = id + 1;
                        }
                    }
                    equipmentVec.append(id.intValue(), ENC.ITEM_ID_BITLEN());
                    break;
                }
                case 2: {
                    GearType safeType = idx < 8 ? EQUIPMENT_ORDER.get(idx) : null;
                    String hash = crafted != null ? CustomCoder.encode(crafted, safeType).toB64() : CustomCoder.encode(gear, safeType).toB64();
                    equipmentVec.append(hash.length(), 12);
                    equipmentVec.appendB64(hash);
                }
            }
            if (!POWDERABLES.containsKey(idx)) continue;
            equipmentVec.merge(Arrays.asList(EncodeDecode.encodePowders(powders.get(POWDERABLES.get(idx)))));
        }
        return equipmentVec;
    }

    public static EncodingBitVector encodeSp(List<Integer> finalSp, List<Integer> assigned) {
        EncodingBitVector spVec = new EncodingBitVector(0L, 0);
        if (assigned.stream().allMatch(x -> x == 0)) {
            spVec.appendFlag(ENC.SP_FLAG(), EncodeDecode.ENC.SP_FLAG().AUTOMATIC);
        } else {
            spVec.appendFlag(ENC.SP_FLAG(), EncodeDecode.ENC.SP_FLAG().ASSIGNED);
            for (int i = 0; i < finalSp.size(); ++i) {
                int sp = finalSp.get(i);
                if (assigned.get(i) == 0) {
                    spVec.appendFlag(ENC.SP_ELEMENT_FLAG(), EncodeDecode.ENC.SP_ELEMENT_FLAG().ELEMENT_UNASSIGNED);
                    continue;
                }
                spVec.appendFlag(ENC.SP_ELEMENT_FLAG(), EncodeDecode.ENC.SP_ELEMENT_FLAG().ELEMENT_ASSIGNED);
                int truncSp = sp & (1 << ENC.MAX_SP_BITLEN()) - 1;
                spVec.append(truncSp, ENC.MAX_SP_BITLEN());
            }
        }
        return spVec;
    }

    public static EncodingBitVector encodeLevel(int level) {
        EncodingBitVector levelVec = new EncodingBitVector(0L, 0);
        if (level == ENC.MAX_LEVEL()) {
            levelVec.appendFlag(ENC.LEVEL_FLAG(), EncodeDecode.ENC.LEVEL_FLAG().MAX);
        } else {
            levelVec.appendFlag(ENC.LEVEL_FLAG(), EncodeDecode.ENC.LEVEL_FLAG().OTHER);
            levelVec.append(level, ENC.LEVEL_BITLEN());
        }
        return levelVec;
    }

    public static EncodingBitVector encodeTomes(@Nullable List<@NotNull Integer> tomes) {
        EncodingBitVector tomesVec = new EncodingBitVector(0L, 0);
        if (tomes == null) {
            tomesVec.appendFlag(ENC.TOMES_FLAG(), EncodeDecode.ENC.TOMES_FLAG().NO_TOMES);
        } else {
            tomesVec.appendFlag(ENC.TOMES_FLAG(), EncodeDecode.ENC.TOMES_FLAG().HAS_TOMES);
            for (Integer tomeId : tomes) {
                if (tomeId == -1) {
                    tomesVec.appendFlag(ENC.TOME_SLOT_FLAG(), EncodeDecode.ENC.TOME_SLOT_FLAG().UNUSED);
                    continue;
                }
                tomesVec.appendFlag(ENC.TOME_SLOT_FLAG(), EncodeDecode.ENC.TOME_SLOT_FLAG().USED);
                tomesVec.append(tomeId.intValue(), ENC.TOME_ID_BITLEN());
            }
        }
        return tomesVec;
    }

    public static EncodingBitVector encodeAspects(@Nullable @Nullable List<@Nullable AspectItem> aspects) {
        EncodingBitVector aspectVec = new EncodingBitVector(0L, 0);
        if (aspects == null) {
            aspectVec.appendFlag(ENC.ASPECTS_FLAG(), EncodeDecode.ENC.ASPECTS_FLAG().NO_ASPECTS);
        } else {
            aspectVec.appendFlag(ENC.ASPECTS_FLAG(), EncodeDecode.ENC.ASPECTS_FLAG().HAS_ASPECTS);
            for (AspectItem aspect : aspects) {
                if (aspect == null) {
                    aspectVec.appendFlag(ENC.ASPECT_SLOT_FLAG(), EncodeDecode.ENC.ASPECT_SLOT_FLAG().UNUSED);
                    continue;
                }
                Integer id = AspectInfo.aspectMap.get(aspect.getName());
                if (id == null) {
                    WynnBuild.warn("Unknown aspect: {}", aspect.getName());
                    aspectVec.appendFlag(ENC.ASPECT_SLOT_FLAG(), EncodeDecode.ENC.ASPECT_SLOT_FLAG().UNUSED);
                    continue;
                }
                aspectVec.appendFlag(ENC.ASPECT_SLOT_FLAG(), EncodeDecode.ENC.ASPECT_SLOT_FLAG().USED);
                aspectVec.append(id.intValue(), ENC.ASPECT_ID_BITLEN());
                aspectVec.append(aspect.getTier() - 1, ENC.ASPECT_TIER_BITLEN());
            }
        }
        return aspectVec;
    }

    public static EncodingBitVector encodeBuild(boolean precise, Build build, List<Integer> finalSkillPoints, List<Integer> assignedSkillpoints, List<AspectItem> aspects, Set<Integer> atreeState) {
        EncodingBitVector finalVec = new EncodingBitVector(0L, 0);
        List<List<Powder>> powderSet = POWDERABLES.keySet().stream().sorted().map(integer -> {
            class_1799 itemStack = build.equipment.get((int)integer);
            Optional gearOpt = Models.Item.asWynnItem(itemStack, GearItem.class);
            if (gearOpt.isPresent()) {
                return ((GearItem)gearOpt.get()).getPowders();
            }
            Optional craftedOpt = Models.Item.asWynnItem(itemStack, CraftedGearItem.class);
            if (craftedOpt.isPresent()) {
                return ((CraftedGearItem)craftedOpt.get()).getPowders();
            }
            return List.of();
        }).toList();
        BitVector[] vectors = new BitVector[]{EncodeDecode.encodeHeader(20), EncodeDecode.encodeEquipment(build.equipment, powderSet, precise), EncodeDecode.encodeTomes(build.tomeIDs), EncodeDecode.encodeSp(finalSkillPoints, assignedSkillpoints), EncodeDecode.encodeLevel(build.wynnLevel), EncodeDecode.encodeAspects(aspects), AtreeCoder.getAtreeCoder(build.cast).encode_atree(atreeState)};
        finalVec.merge(Arrays.asList(vectors));
        return finalVec;
    }
}

