/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.base.util;

import com.gertoxq.wynnbuild.base.util.BitVector;

public class BitVectorCursor {
    public BitVector bitVector;
    public int currentIndex;
    public int endIndex;

    public BitVectorCursor(BitVector bitVector, int index, int span) {
        if (span < 0 || index < 0) {
            throw new IllegalArgumentException("Index or span cannot be negative");
        }
        if (index + span > bitVector.length) {
            throw new IllegalArgumentException("Span exceeds the length of the BitVector");
        }
        this.bitVector = bitVector;
        this.currentIndex = index;
        this.endIndex = index + span;
    }

    public BitVectorCursor(BitVector bitVector, int index) {
        this(bitVector, index, bitVector.length - index);
    }

    public BitVectorCursor(BitVector bitVector) {
        this(bitVector, 0);
    }

    public BitVectorCursor spawn(int span, int index) {
        return new BitVectorCursor(this.bitVector, index, span);
    }

    public BitVectorCursor spawn(int span) {
        return this.spawn(span, this.currentIndex);
    }

    public boolean end() {
        return this.currentIndex == this.endIndex;
    }

    public long advance() {
        assert (!this.end()) : "Cannot advance beyond the end of the BitVector";
        int index = this.currentIndex++;
        return this.bitVector.readBit(index);
    }

    public int advanceBy(int amount) {
        if (this.currentIndex + amount > this.endIndex) {
            throw new IllegalArgumentException("Cannot advance beyond the end of the BitVector");
        }
        int index = this.currentIndex;
        this.currentIndex += amount;
        return (int)this.bitVector.slice(index, this.currentIndex);
    }

    public String advanceByChars(int amount) {
        int index = this.currentIndex;
        this.currentIndex += amount * 6;
        return this.bitVector.sliceB64(index, this.currentIndex);
    }

    public void skip(int amount) {
        assert (this.currentIndex + amount <= this.endIndex) : "Can't skip beyond end";
        this.currentIndex += amount;
    }

    public BitVector consume() {
        int len;
        int index = this.currentIndex;
        this.currentIndex = this.endIndex;
        BitVector vec = new BitVector(0L, 0);
        for (len = this.endIndex - index; len > 32; len -= 32) {
            vec.append(this.bitVector.slice(index, index + 32), 32);
            index += 32;
        }
        vec.append(this.bitVector.slice(index, index + len), len);
        this.bitVector = null;
        return vec;
    }
}

