/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.base.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public class Uint32Array {
    public static final int BYTES_PER_ELEMENT = 4;
    private final ByteBuffer buffer;
    private final int byteOffset;
    private final int length;

    private Uint32Array(ByteBuffer buffer, int byteOffset, int length) {
        this.buffer = buffer;
        this.byteOffset = byteOffset;
        this.length = length;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public Uint32Array(int length) {
        this(ByteBuffer.allocate(length * 4), 0, length);
    }

    public Uint32Array(long[] array) {
        this(array.length);
        this.set(array, 0);
    }

    public Uint32Array(byte[] array) {
        if (array.length % 4 != 0) {
            throw new IllegalArgumentException("Byte array length must be a multiple of 4.");
        }
        this.length = array.length / 4;
        this.byteOffset = 0;
        this.buffer = ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
    }

    public Uint32Array(Uint32Array array) {
        this(array.length);
        this.set(array, 0);
    }

    public int length() {
        return this.length;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public int byteOffset() {
        return this.byteOffset;
    }

    public int byteLength() {
        return this.length * 4;
    }

    public long get(int index) {
        this.checkIndex(index);
        return Integer.toUnsignedLong(this.buffer.getInt(this.byteOffset + index * 4));
    }

    public void set(int index, long value) {
        this.checkIndex(index);
        this.buffer.putInt(this.byteOffset + index * 4, (int)value);
    }

    public void set(long[] source, int offset) {
        this.checkOffset(offset, source.length);
        for (int i = 0; i < source.length; ++i) {
            this.set(offset + i, source[i]);
        }
    }

    public void set(List<Long> source, int offset) {
        this.checkOffset(offset, source.size());
        for (int i = 0; i < source.size(); ++i) {
            this.set(offset + i, source.get(i));
        }
    }

    public void set(Uint32Array source, int offset) {
        this.checkOffset(offset, source.length());
        Uint32Array src = source;
        if (this.buffer == src.buffer()) {
            src = src.slice(0, src.length());
        }
        for (int i = 0; i < src.length(); ++i) {
            this.set(offset + i, src.get(i));
        }
    }

    public Uint32Array subarray(int begin, int end) {
        if (begin < 0 || end < 0 || begin > end || end > this.length) {
            throw new IndexOutOfBoundsException("Invalid subarray range: begin=" + begin + ", end=" + end + ", length=" + this.length);
        }
        int newLength = end - begin;
        int newByteOffset = this.byteOffset + begin * 4;
        return new Uint32Array(this.buffer, newByteOffset, newLength);
    }

    public Uint32Array slice(int begin, int end) {
        if (begin < 0 || end < 0 || begin > end || end > this.length) {
            throw new IndexOutOfBoundsException("Invalid slice range: begin=" + begin + ", end=" + end + ", length=" + this.length);
        }
        int newLength = end - begin;
        Uint32Array newArray = new Uint32Array(newLength);
        ByteBuffer newBuf = newArray.buffer();
        ByteBuffer oldBuf = this.buffer.duplicate();
        oldBuf.position(this.byteOffset + begin * 4);
        oldBuf.limit(this.byteOffset + end * 4);
        newBuf.put(oldBuf);
        newBuf.flip();
        return newArray;
    }

    public void fill(long value, int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this.length) {
            throw new IndexOutOfBoundsException("Invalid fill range: start=" + start + ", end=" + end + ", length=" + this.length);
        }
        int intValue = (int)value;
        for (int i = start; i < end; ++i) {
            this.buffer.putInt(this.byteOffset + i * 4, intValue);
        }
    }

    public void fill(long value) {
        this.fill(value, 0, this.length);
    }

    public void sort() {
        long[] temp = new long[this.length];
        for (int i = 0; i < this.length; ++i) {
            temp[i] = this.get(i);
        }
        Arrays.sort(temp);
        this.set(temp, 0);
    }

    public void reverse() {
        for (int i = 0; i < this.length / 2; ++i) {
            int j = this.length - 1 - i;
            long temp = this.get(i);
            this.set(i, this.get(j));
            this.set(j, temp);
        }
    }

    public String toString() {
        return LongStream.range(0L, this.length).mapToObj(i -> String.valueOf(this.get((int)i))).collect(Collectors.joining(", ", "[", "]"));
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.length);
        }
    }

    private void checkOffset(int offset, int sourceLength) {
        if (offset < 0 || offset > this.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is out of bounds for length " + this.length);
        }
        if (offset + sourceLength > this.length) {
            throw new IllegalArgumentException("Source array is too large to fit at offset " + offset);
        }
    }
}

