/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.screens.tome;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.util.WynnData;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.handlers.container.type.ContainerContentChangeType;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.utils.mc.LoreUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class TomeQuery {
    public static final List<Integer> EMPTY_IDS = Collections.nCopies(14, -1);
    public static final List<Integer> TOME_SLOTS = List.of(11, 19, 22, 30, 31, 32, 4, 49, 15, 25, 28, 38, 34, 42);
    private static final int TOME_SLOT = 8;
    private static final int TOME_MENU_CONTENT_BOOK_SLOT = 89;

    public void queryTomeInfo() {
        ScriptedContainerQuery tomeQuery = ScriptedContainerQuery.builder((String)"wynnbuild.tomequery").onError(err -> System.out.println("wynnbuild.tomequery: " + err)).then(QueryStep.useItemInHotbar((int)7).expectContainerTitle("\udaff\udfdc\ue003").processIncomingContainer(this::processTomeUnlocked)).conditionalThen(this::checkTomesUnlocked, QueryStep.clickOnSlot((int)8).expectContainerTitle("\udaff\udfdb\ue005").verifyContentChange(this::verifyChange).processIncomingContainer(this::processTomes)).execute(() -> WynnBuild.info("Read tomes: {}", WynnBuild.tomeIds)).build();
        tomeQuery.executeQuery();
    }

    public void processTomes(ContainerContent content) {
        WynnBuild.tomeIds = this.getTomeIds(content);
    }

    private List<Integer> getTomeIds(ContainerContent content) {
        return TOME_SLOTS.stream().map(slot -> {
            Optional tomeOptional = Models.Item.asWynnItem((class_1799)content.items().get((int)slot), TomeItem.class);
            if (tomeOptional.isEmpty()) {
                return -1;
            }
            Optional<Integer> optionalId = Optional.ofNullable(WynnData.getTomeMap().get(((TomeItem)tomeOptional.get()).getName()));
            if (optionalId.isEmpty()) {
                WynnBuild.warn("Unknown tome: name={}", ((TomeItem)tomeOptional.get()).getName());
            }
            return optionalId.orElse(-1);
        }).toList();
    }

    private boolean verifyChange(ContainerContent content, Int2ObjectFunction<class_1799> changes, ContainerContentChangeType changeType) {
        return changeType == ContainerContentChangeType.SET_CONTENT && changes.containsKey(89) && ((class_1799)content.items().get(89)).method_7909() == class_1802.field_8574;
    }

    private boolean checkTomesUnlocked(ContainerContent content) {
        return LoreUtils.getStringLore((class_1799)((class_1799)content.items().get(8))).contains("\u2714");
    }

    public void processTomeUnlocked(ContainerContent content) {
        if (!this.checkTomesUnlocked(content)) {
            WynnBuild.tomeIds = EMPTY_IDS;
        }
    }
}

