/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.build;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.base.util.BitVector;
import com.gertoxq.wynnbuild.screens.atree.Ability;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.models.character.type.ClassType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class AtreeCoder {
    private final JsonObject castTreeObj;

    private AtreeCoder(JsonObject castTreeObj) {
        this.castTreeObj = castTreeObj;
    }

    public static AtreeCoder getAtreeCoder(ClassType cast) {
        return new AtreeCoder(Ability.fullatree.get(cast.getName()).getAsJsonObject());
    }

    public BitVector encode_atree(Set<Integer> atree_state) {
        BitVector ret_vec = new BitVector(0L, 0);
        this.traverse(0, atree_state, new HashSet<Integer>(), ret_vec);
        return ret_vec;
    }

    private void traverse(int id, Set<Integer> atree_state, Set<Integer> visited, BitVector ret) {
        if (this.castTreeObj == null) {
            WynnBuild.error("CastTree is null", new Object[0]);
            return;
        }
        JsonObject head = this.castTreeObj.get(String.valueOf(id)).getAsJsonObject();
        for (JsonElement child : head.get("children").getAsJsonArray()) {
            int kidId = child.getAsInt();
            if (visited.contains(kidId)) continue;
            visited.add(kidId);
            if (atree_state.contains(kidId)) {
                ret.append(1L, 1);
                this.traverse(kidId, atree_state, visited, ret);
                continue;
            }
            ret.append(0L, 1);
        }
    }

    public Set<Integer> decode_atree(String encoded) {
        BitVector bits = new BitVector(encoded);
        AtomicInteger i = new AtomicInteger();
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(0);
        this.traverse(0, new HashSet<Integer>(), ret, bits, i);
        return ret;
    }

    private void traverse(int id, Set<Integer> visited, Set<Integer> ret, BitVector bits, AtomicInteger i) {
        if (this.castTreeObj == null) {
            WynnBuild.error("CastTree is null", new Object[0]);
            return;
        }
        JsonObject head = this.castTreeObj.get(String.valueOf(id)).getAsJsonObject();
        for (JsonElement child : head.get("children").getAsJsonArray()) {
            int kidId = child.getAsInt();
            if (visited.contains(kidId)) continue;
            visited.add(kidId);
            if (bits.readBit(i.getAndAdd(1)) == 0) continue;
            ret.add(kidId);
            this.traverse(kidId, visited, ret, bits, i);
        }
    }
}

