/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.screens.aspect;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.util.Utils;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.handlers.container.type.ContainerContentChangeType;
import com.wynntils.models.containers.ContainerModel;
import com.wynntils.models.items.items.game.AspectItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1799;

public class AspectInfo {
    public static final Pattern ASPECT_TITLE_PATTERN = Pattern.compile("\udaff\udfea\ue002");
    private static final List<Integer> ASPECT_SLOTS = List.of(Integer.valueOf(18), Integer.valueOf(11), Integer.valueOf(4), Integer.valueOf(15), Integer.valueOf(26));
    private static final Pattern EMPTY_ASPECT_PATTERN = Pattern.compile("^(?:\u00a7.)*Empty Aspect Socket$");
    private static final Pattern LOCKED_ASPECT_PATTERN = Pattern.compile("^(?:\u00a7.)*Locked Aspect Socket$");
    public static Map<String, Integer> aspectMap;

    public void queryAspectInfo() {
        ScriptedContainerQuery query = ScriptedContainerQuery.builder((String)"wynnbuild.fetchaspect").onError(string -> WynnBuild.warn("Error querying aspect info: {}", Utils.escapeToUnicode(string))).then(QueryStep.useItemInHotbar((int)7).expectContainerTitle("\udaff\udfdc\ue003")).then(QueryStep.clickOnSlot((int)9).expectContainerTitle(ContainerModel.ABILITY_TREE_PATTERN.pattern())).then(QueryStep.clickOnSlot((int)86).expectContainerTitle(ContainerModel.ABILITY_TREE_PATTERN.pattern())).then(QueryStep.clickOnSlot((int)0).verifyContentChange(this::verifyChange).expectContainerTitle(ASPECT_TITLE_PATTERN.pattern()).processIncomingContainer(this::processAspects)).execute(() -> WynnBuild.info("Fetched Aspects: " + WynnBuild.aspects.stream().map(AspectItem::getName).collect(Collectors.joining(", ")), new Object[0])).build();
        query.executeQuery();
    }

    private boolean verifyChange(ContainerContent content, Int2ObjectFunction<class_1799> changes, ContainerContentChangeType changeType) {
        return changes.containsKey(54);
    }

    public void processAspects(ContainerContent content) {
        ArrayList<AspectItem> aspects = new ArrayList<AspectItem>();
        ASPECT_SLOTS.forEach(slot -> {
            Optional aspectOpt = Models.Item.asWynnItem((class_1799)content.items().get((int)slot), AspectItem.class);
            aspectOpt.ifPresentOrElse(foundAspect -> {
                Integer aspectId = aspectMap.get(foundAspect.getName());
                if (aspectId == null) {
                    WynnBuild.warn("Could not find aspect id for {} {}", foundAspect.getRequiredClass().getName(), foundAspect.getName());
                    return;
                }
                aspects.add((AspectItem)aspectOpt.get());
            }, () -> aspects.add(null));
        });
        WynnBuild.aspects = aspects;
    }

    public boolean verifyValidAspectContainer(ContainerContent content) {
        return ASPECT_SLOTS.stream().allMatch(slot -> Models.Item.asWynnItem((class_1799)content.items().get((int)slot), AspectItem.class).isPresent() || EMPTY_ASPECT_PATTERN.matcher(((class_1799)content.items().get((int)slot)).method_7964().getString()).matches() || LOCKED_ASPECT_PATTERN.matcher(((class_1799)content.items().get((int)slot)).method_7964().getString()).matches());
    }
}

