/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.screens.atree;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.screens.atree.Ability;
import com.gertoxq.wynnbuild.screens.atree.AtreeNode;
import com.gertoxq.wynnbuild.util.Utils;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.models.containers.ContainerModel;
import com.wynntils.utils.mc.McUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;

public class AbilityTreeQuery {
    public static final int PREVIOUS_PAGE_SLOT = 57;
    public static final int NEXT_PAGE_SLOT = 59;
    public static final int ABILITY_TREE_SLOT = 9;
    static final StyledText NEXT_PAGE_ITEM_NAME = StyledText.fromString((String)"\u00a77Next Page");
    static final StyledText PREVIOUS_PAGE_ITEM_NAME = StyledText.fromString((String)"\u00a77Previous Page");
    private int pageCount;

    public AbilityTreeQuery() {
        WynnBuild.atreeState = new HashSet<Integer>();
    }

    public void queryTree() {
        this.queryTree(() -> {});
    }

    public void queryTree(Runnable after) {
        AtreeFetcher processor = new AtreeFetcher();
        ScriptedContainerQuery query = ScriptedContainerQuery.builder((String)"wynnbuild.treequery").onError(err -> WynntilsMod.warn((String)("wynnbuild.treequery: " + err))).then(QueryStep.useItemInHotbar((int)7).expectContainerTitle("\udaff\udfdc\ue003")).then(QueryStep.clickOnSlot((int)9).expectContainerTitle(ContainerModel.ABILITY_TREE_PATTERN.pattern())).execute(() -> {
            this.pageCount = 0;
        }).repeat(c -> ScriptedContainerQuery.containerHasSlot((ContainerContent)c, (int)57, (class_1792)class_1802.field_8574, (StyledText)PREVIOUS_PAGE_ITEM_NAME), QueryStep.clickOnSlot((int)57).processIncomingContainer(c -> ++this.pageCount)).reprocess(processor::processPage).repeat(c -> ScriptedContainerQuery.containerHasSlot((ContainerContent)c, (int)59, (class_1792)class_1802.field_8574, (StyledText)NEXT_PAGE_ITEM_NAME) && processor.doContinue(), QueryStep.clickOnSlot((int)59).processIncomingContainer(processor::processPage)).execute(() -> McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Ability tree fetched").method_27694(style -> style.method_10977(class_124.field_1080)))).execute(after).build();
        query.executeQuery();
    }

    public static class AtreeFetcher {
        private int page = 1;
        private boolean doContinue = true;

        protected void processPage(ContainerContent content, int page) {
            List items = content.items();
            HashSet<AtreeNode> allPossibleNodes = new HashSet<AtreeNode>();
            WynnBuild.debug("Processing ability tree page {}", page);
            WynnBuild.debug("Existing nodes {}", Arrays.toString(WynnBuild.atreeState.toArray()));
            AtomicInteger i = new AtomicInteger(0);
            while (i.get() < 54) {
                class_1799 stack = (class_1799)items.get(i.get());
                if (!stack.method_7960() && Utils.getLore(stack) != null && !Utils.getLore(stack).isEmpty()) {
                    AtreeNode node = new AtreeNode(stack, i.get());
                    WynnBuild.debug("Found node at {}", String.valueOf(i.get()));
                    WynnBuild.debug("Processing node {}", node.getName());
                    if (node.getId().isEmpty()) {
                        WynnBuild.debug("No ability id found for node {}", i.get() + ":" + node.getName());
                    } else if (!node.isUnlockedOrUnreachable()) {
                        WynnBuild.debug("Unreachable node", new Object[0]);
                    } else {
                        allPossibleNodes.add(node);
                    }
                }
                i.getAndIncrement();
            }
            Set<Integer> pageUnlocked = this.findUnlocked(allPossibleNodes.stream().map(atreeNode -> atreeNode.id).collect(Collectors.toSet()));
            if (pageUnlocked.isEmpty()) {
                this.doContinue = false;
            }
            WynnBuild.debug("Unlocked nodes on page {}", Arrays.toString(pageUnlocked.toArray()));
            WynnBuild.atreeState.addAll(pageUnlocked);
            WynnBuild.debug("Nodes at page end {}", Arrays.toString(WynnBuild.atreeState.toArray()));
        }

        public boolean doContinue() {
            return this.doContinue;
        }

        private Set<Integer> roots(Set<Integer> all) {
            return all.stream().filter(id -> {
                if (id == 0) {
                    return true;
                }
                List<Integer> parents = Ability.getById(id).parents();
                return parents.stream().anyMatch(WynnBuild.atreeState::contains);
            }).collect(Collectors.toSet());
        }

        private Set<Integer> findUnlocked(Set<Integer> all) {
            Set<Integer> roots = this.roots(all);
            HashSet<Integer> unlocked = new HashSet<Integer>(roots);
            roots.forEach(root -> this.recurseNodes((int)root, all, (Set<Integer>)unlocked));
            return unlocked;
        }

        private void recurseNodes(int id, Set<Integer> allNodes, Set<Integer> unlocked) {
            Ability.getById(id).children().stream().filter(child -> allNodes.contains(child) && !unlocked.contains(child)).forEach(child -> {
                unlocked.add((Integer)child);
                this.recurseNodes((int)child, allNodes, unlocked);
            });
        }

        protected void processPage(ContainerContent content) {
            this.processPage(content, this.page);
            ++this.page;
        }
    }
}

