/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild;

import com.gertoxq.wynnbuild.base.custom.CustomCoder;
import com.gertoxq.wynnbuild.base.sp.Skillpoint;
import com.gertoxq.wynnbuild.build.AtreeCoder;
import com.gertoxq.wynnbuild.build.Build;
import com.gertoxq.wynnbuild.config.ConfigType;
import com.gertoxq.wynnbuild.config.Manager;
import com.gertoxq.wynnbuild.screens.QueryStack;
import com.gertoxq.wynnbuild.util.Utils;
import com.wynntils.core.components.Models;
import com.wynntils.models.character.SkillPointModel;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WynnBuild
implements ModInitializer {
    public static final String DOMAIN = "https://wynnbuilder.github.io/";
    public static final String BUILDER_DOMAIN = "https://wynnbuilder.github.io/builder/#";
    public static final String WYNNCUSTOM_DOMAIN = "https://wynnbuilder.github.io/custom/#";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wynnbuild");
    private static final boolean debug = false;
    public static class_310 client;
    public static Manager configManager;
    public static List<Integer> tomeIds;
    public static List<AspectItem> aspects;
    public static Set<Integer> atreeState;
    public static List<class_1799> currentGear;
    private static QueryStack currentQuery;

    public static Manager getConfigManager() {
        return configManager;
    }

    public static ConfigType getConfig() {
        return WynnBuild.getConfigManager().getConfig();
    }

    public static Optional<QueryStack> getQuery() {
        return Optional.ofNullable(currentQuery);
    }

    public static void setQuery(QueryStack query) {
        currentQuery = query;
    }

    public static List<class_1799> getPlayerEquipment() {
        ArrayList<class_1799> equipment = new ArrayList<class_1799>((Collection<class_1799>)McUtils.inventory().field_7548);
        Collections.reverse(equipment);
        for (int i : InventoryAccessory.getSlots()) {
            int baseSize = 0;
            if (McUtils.player().method_45015()) {
                baseSize = McUtils.player().field_7512.method_7602().size();
            }
            equipment.add(McUtils.inventory().method_5438(i + baseSize));
        }
        Optional handItemOpt = Models.Item.asWynnItem(McUtils.player().method_5998(class_1268.field_5808), GearItem.class);
        if (!(handItemOpt.isPresent() && ((GearItem)handItemOpt.get()).meetsActualRequirements() && ((GearItem)handItemOpt.get()).getGearType().isWeapon())) {
            WynnBuild.displayErr("Hold a weapon");
            return null;
        }
        equipment.add(McUtils.player().method_5998(class_1268.field_5808));
        return equipment;
    }

    public static void buildMainHand() {
        WynnBuild.buildItemStackCustom(McUtils.player().method_5998(class_1268.field_5808));
    }

    public static void buildItemStackCustom(class_1799 itemStack) {
        Optional gearItemOpt = Models.Item.asWynnItem(itemStack, GearItem.class);
        if (gearItemOpt.isEmpty()) {
            return;
        }
        String customHash = CustomCoder.encode((GearItem)gearItemOpt.get(), null).toB64();
        String url = WYNNCUSTOM_DOMAIN + customHash;
        String fullHash = "CI-" + customHash;
        WynnBuild.message(Utils.getItemPrintTemplate((GearItem)gearItemOpt.get(), fullHash, url));
    }

    public static void buildWithArgs(boolean forceRefetchAtree) {
        if (WynnBuild.client.field_1724 == null) {
            return;
        }
        currentGear = WynnBuild.getPlayerEquipment();
        if (currentGear == null) {
            return;
        }
        boolean tomesEnabled = WynnBuild.getConfig().isIncludeTomes();
        boolean aspectsEnabled = WynnBuild.getConfig().isIncludeAspects();
        QueryStack.Builder query = QueryStack.builder();
        if (tomesEnabled && tomeIds == null) {
            query.next(QueryStack.ContainerType.TOME);
        }
        if (aspectsEnabled && aspects == null) {
            query.next(QueryStack.ContainerType.ASPECTS);
        }
        if (atreeState.isEmpty() || forceRefetchAtree) {
            if (atreeState.isEmpty()) {
                WynnBuild.message((class_2561)class_2561.method_43470((String)"Querying ability tree...").method_27694(style -> style.method_10977(class_124.field_1080)));
            }
            query.next(QueryStack.ContainerType.SKILLPOINTS).next(QueryStack.ContainerType.ATREE).next(QueryStack.ContainerType.BUILD);
        } else {
            query.next(QueryStack.ContainerType.SKILLPOINTS).next(QueryStack.ContainerType.BUILD);
        }
        query.runQuery();
    }

    public static void buildAfterSp() {
        List<Integer> totalSp = Arrays.stream(Skill.values()).map(arg_0 -> ((SkillPointModel)Models.SkillPoint).getTotalSkillPoints(arg_0)).toList();
        List<Integer> manualPoints = Arrays.stream(Skill.values()).map(Skillpoint::getManualPoints).toList();
        new Build(currentGear, WynnBuild.getConfig().getPrecision() == 1, totalSp, manualPoints, Models.CharacterStats.getLevel(), tomeIds, atreeState, aspects).display();
    }

    public static void build() {
        WynnBuild.buildWithArgs(false);
    }

    public static void displayErr(String errorMessage) {
        WynnBuild.message((class_2561)class_2561.method_43470((String)errorMessage).method_27694(style -> style.method_10977(class_124.field_1061)));
        client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14833, (float)1.0f, (float)1.0f));
    }

    public static AtreeCoder getAtreeCoder() {
        return AtreeCoder.getAtreeCoder(Models.Character.getClassType());
    }

    public static String getAtreeSuffix() {
        return WynnBuild.getAtreeCoder().encode_atree(atreeState).toB64();
    }

    public static void warn(String format, Object ... args) {
        LOGGER.warn(format, args);
    }

    public static void info(String format, Object ... args) {
        LOGGER.info(format, args);
    }

    public static void error(String format, Object ... args) {
        LOGGER.error(format, args);
    }

    public static void debug(String format, Object ... args) {
    }

    public static void debugClient(String message) {
    }

    public static void message(class_2561 text) {
        assert (McUtils.player() != null) : "Cannot send message, there is no player";
        McUtils.player().method_7353(text, false);
    }

    public void onInitialize() {
    }

    private static /* synthetic */ class_2583 lambda$debugClient$3(class_2583 style) {
        return style.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1068);
    }

    private static /* synthetic */ class_2583 lambda$debugClient$2(class_2583 style) {
        return style.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1065);
    }

    static {
        tomeIds = null;
        aspects = null;
        atreeState = new HashSet<Integer>();
        currentGear = null;
        currentQuery = null;
    }
}

