/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.config;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.config.ConfigType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class Manager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config/wynnbuild.json", new String[0]);
    private ConfigType config;

    public void loadConfig() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                this.config = new ConfigType();
                this.saveConfig();
            } else {
                BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
                this.config = (ConfigType)GSON.fromJson((Reader)reader, ConfigType.class);
                reader.close();
            }
        }
        catch (IOException e) {
            WynnBuild.error(e.getMessage(), new Object[0]);
        }
    }

    public void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);
            GSON.toJson((Object)this.config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            WynnBuild.error(e.getMessage(), new Object[0]);
        }
    }

    public ConfigType getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    public void setConfig(ConfigType config) {
        this.config = config;
        this.saveConfig();
    }
}

