/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.util;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.screens.atree.Ability;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class WynnData {
    private static final Map<String, String> apiBuilderMap = new HashMap<String, String>();

    public static Map<String, String> getApiBuilderMap() {
        return apiBuilderMap;
    }

    public static void loadAll() {
        WynnData.loadAtree();
        WynnData.loadApiBuilderMapping();
    }

    public static void loadAtree() {
        InputStream atreeStream = WynnBuild.class.getResourceAsStream("/atree.json");
        assert (atreeStream != null);
        Ability.fullatree = ((JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(atreeStream, StandardCharsets.UTF_8))).asMap();
    }

    public static void loadApiBuilderMapping() {
        InputStream mappingsStream = WynnBuild.class.getResourceAsStream("/apibuildermap.json");
        assert (mappingsStream != null);
        ((JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(mappingsStream, StandardCharsets.UTF_8))).asMap().forEach((api, builderEl) -> {
            String builder = builderEl.getAsString();
            apiBuilderMap.put((String)api, builder);
        });
    }
}

