/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.webquery;

import com.gertoxq.wynnbuild.WynnBuild;
import com.gertoxq.wynnbuild.webquery.DataProvider;
import com.gertoxq.wynnbuild.webquery.HttpHelper;
import com.gertoxq.wynnbuild.webquery.Providers;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuilderDataManager {
    public static String LATEST_WYNNBUILDER_VERSION;
    public static int WYNN_VERSION_ID;
    private static final Pattern VERSION_STRING_PATTERN;
    private static final String VERSION_FILE_URL = "https://raw.githubusercontent.com/wynnbuilder/wynnbuilder.github.io/refs/heads/master/js/load_item.js";

    public static void initBuilderData() {
        BuilderDataManager.reloadBuilderData(false);
    }

    public static void reloadBuilderData(boolean ignoreCache) {
        ((CompletableFuture)HttpHelper.get(VERSION_FILE_URL).thenAccept(res -> {
            Matcher matcher = VERSION_STRING_PATTERN.matcher((CharSequence)res.body());
            int count = 0;
            String last = null;
            while (matcher.find()) {
                last = matcher.group(1);
                ++count;
            }
            WYNN_VERSION_ID = count - 1;
            LATEST_WYNNBUILDER_VERSION = last;
            WynnBuild.info("Wynnbuilder version: {} (id: {})", LATEST_WYNNBUILDER_VERSION, WYNN_VERSION_ID);
            Arrays.stream(Providers.class.getDeclaredFields()).forEach(field -> {
                try {
                    WynnBuild.info("Trying to load provider from field: {}", field.getName());
                    field.setAccessible(true);
                    DataProvider provider = (DataProvider)field.get(null);
                    BuilderDataManager.processProvider(provider, ignoreCache);
                }
                catch (Exception e) {
                    WynnBuild.error("Failed to load provider from field {}. Error: {}", field.getName(), e.getMessage());
                }
            });
        })).exceptionally(throwable -> {
            WynnBuild.error("Failed to get latest version file. Error: {}", throwable.getMessage());
            return null;
        });
    }

    private static <T> void processProvider(DataProvider<T> provider, boolean ignoreCache) {
        Optional<Map<String, T>> cacheDataOpt;
        Optional<String> cacheVerOpt;
        if (!ignoreCache && (cacheVerOpt = provider.getCacheVersion()).isPresent() && cacheVerOpt.get().equals(LATEST_WYNNBUILDER_VERSION) && (cacheDataOpt = provider.getCacheData()).isPresent()) {
            provider.setData(cacheDataOpt.get());
            WynnBuild.info("Loaded cached entries for provider {}", provider.getClass().getSimpleName());
            return;
        }
        ((CompletableFuture)((CompletableFuture)HttpHelper.get(provider.url(LATEST_WYNNBUILDER_VERSION)).thenApply(providerRes -> {
            Map dataMap = provider.transformData(JsonParser.parseString((String)((String)providerRes.body())).getAsJsonObject());
            provider.setCache(dataMap, LATEST_WYNNBUILDER_VERSION);
            return dataMap;
        })).thenAccept(stringTMap -> {
            provider.setData((Map)stringTMap);
            WynnBuild.info("Loaded web entries for provider {}", provider.getClass().getSimpleName());
        })).exceptionally(throwable -> {
            WynnBuild.error("Failed to load entries for provider {}. Err: {}", provider.getClass().getSimpleName(), throwable.getMessage());
            return null;
        });
    }

    static {
        VERSION_STRING_PATTERN = Pattern.compile("'((?:\\d+\\.){3}\\d+)'");
    }
}

