/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.webquery;

import com.gertoxq.wynnbuild.WynnBuild;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;

public abstract class DataProvider<V> {
    private static final File cacheDir = new File(McUtils.mc().field_1697, "cache/wynnbuild");
    private static final String dataFolderUrl = "https://raw.githubusercontent.com/wynnbuilder/wynnbuilder.github.io/refs/heads/master/data/";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final String name;
    private Map<String, V> data;
    private final File cacheFile;
    private final Type dataType;

    public DataProvider(String name, Type dataType) {
        this.name = name;
        this.cacheFile = new File(cacheDir, name + ".json");
        this.dataType = dataType;
    }

    public Map<String, V> data() {
        return this.data;
    }

    public String url(String version) {
        return dataFolderUrl + version + "/" + this.name + ".json";
    }

    protected abstract Map<String, V> transformData(JsonObject var1);

    public void setData(Map<String, V> data) {
        this.data = data;
    }

    public void setCache(Map<String, V> dataMap, String version) {
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        if (!this.cacheFile.exists()) {
            FileUtils.createNewFile((File)this.cacheFile);
        }
        JsonObject cacheObject = new JsonObject();
        cacheObject.addProperty("version", version);
        cacheObject.add("data", gson.toJsonTree(dataMap));
        try {
            Files.writeString(this.cacheFile.toPath(), (CharSequence)gson.toJson((JsonElement)cacheObject), new OpenOption[0]);
        }
        catch (IOException e) {
            WynnBuild.warn("Failed to write cache. Error: {}", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<JsonObject> readCacheFile() {
        if (!this.cacheFile.exists()) {
            return Optional.empty();
        }
        try (FileReader reader = new FileReader(this.cacheFile);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element == null || !element.isJsonObject()) {
                WynnBuild.warn("Cache file {} is not a valid JSON object.", this.cacheFile.getName());
                Optional<JsonObject> optional = Optional.empty();
                return optional;
            }
            Optional<JsonObject> optional = Optional.of(element.getAsJsonObject());
            return optional;
        }
        catch (JsonParseException | IOException e) {
            WynnBuild.error("Failed to read cache file {}. Error: {}", this.cacheFile.getName(), e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<String> getCacheVersion() {
        return this.readCacheFile().map(cacheData -> cacheData.get("version")).filter(element -> !element.isJsonNull() && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()).map(JsonElement::getAsString);
    }

    public Optional<Map<String, V>> getCacheData() {
        Optional<JsonObject> cacheDataOpt = this.readCacheFile();
        if (cacheDataOpt.isEmpty()) {
            return Optional.empty();
        }
        JsonObject cacheData = cacheDataOpt.get();
        return Optional.ofNullable((Map)gson.fromJson(cacheData.get("data"), this.dataType));
    }
}

