/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.base.bitcodemaps;

import com.wynntils.models.elements.type.Element;
import java.util.Arrays;
import java.util.List;

public interface BitMapEncoding {
    default public EquimpentKind EQUIPMENT_KIND() {
        return new EquimpentKind();
    }

    default public EquipmentPowdersFlag EQUIPMENT_POWDERS_FLAG() {
        return new EquipmentPowdersFlag();
    }

    default public int EQUIPMENT_NUM() {
        return 9;
    }

    default public int POWDERABLE_EQUIPMENT_NUM() {
        return 5;
    }

    default public List<String> POWDER_ELEMENTS() {
        return Arrays.stream(Element.values()).map(element -> element.name().substring(0, 1)).toList();
    }

    default public int POWDER_TIERS() {
        return 6;
    }

    default public int POWDER_WRAPPER_BITLEN() {
        return 2;
    }

    default public int POWDER_ID_BITLEN() {
        return 5;
    }

    default public PowderRepeatOp POWDER_REPEAT_OP() {
        return new PowderRepeatOp();
    }

    default public PowderRepeatTierOp POWDER_REPEAT_TIER_OP() {
        return new PowderRepeatTierOp();
    }

    default public PowderChangeOp POWDER_CHANGE_OP() {
        return new PowderChangeOp();
    }

    default public TomesFlag TOMES_FLAG() {
        return new TomesFlag();
    }

    default public TomeSlotFlag TOME_SLOT_FLAG() {
        return new TomeSlotFlag();
    }

    default public int TOME_NUM() {
        return 14;
    }

    default public int ASPECT_TIERS() {
        return 4;
    }

    default public int NUM_ASPECTS() {
        return 5;
    }

    default public int ASPECT_TIER_BITLEN() {
        return 2;
    }

    default public AspectsFlag ASPECTS_FLAG() {
        return new AspectsFlag();
    }

    default public AspectSlotFlag ASPECT_SLOT_FLAG() {
        return new AspectSlotFlag();
    }

    default public int MAX_SP() {
        return 2048;
    }

    default public int SP_TYPES() {
        return 5;
    }

    default public int MAX_SP_BITLEN() {
        return 12;
    }

    default public SpFlag SP_FLAG() {
        return new SpFlag();
    }

    default public SpElementFlag SP_ELEMENT_FLAG() {
        return new SpElementFlag();
    }

    default public LevelFlag LEVEL_FLAG() {
        return new LevelFlag();
    }

    default public int MAX_LEVEL() {
        return 106;
    }

    default public int LEVEL_BITLEN() {
        return 7;
    }

    default public int ITEM_ID_BITLEN() {
        return 13;
    }

    default public int TOME_ID_BITLEN() {
        return 8;
    }

    default public int ASPECT_ID_BITLEN() {
        return 5;
    }

    public static class EquimpentKind
    implements BitSized {
        public final int NORMAL = 0;
        public final int CRAFTED = 1;
        public final int CUSTOM = 2;

        @Override
        public int BITLEN() {
            return 2;
        }
    }

    public static class EquipmentPowdersFlag
    implements BitSized {
        public final int NO_POWDERS = 0;
        public final int HAS_POWDERS = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class PowderRepeatOp
    implements BitSized {
        public final int REPEAT = 0;
        public final int NO_REPEAT = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class PowderRepeatTierOp
    implements BitSized {
        public final int REPEAT_TIER = 0;
        public final int CHANGE_POWDER = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class PowderChangeOp
    implements BitSized {
        public final int NEW_POWDER = 0;
        public final int NEW_ITEM = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class TomesFlag
    implements BitSized {
        public final int NO_TOMES = 0;
        public final int HAS_TOMES = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class TomeSlotFlag
    implements BitSized {
        public final int UNUSED = 0;
        public final int USED = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class AspectsFlag
    implements BitSized {
        public final int NO_ASPECTS = 0;
        public final int HAS_ASPECTS = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class AspectSlotFlag
    implements BitSized {
        public final int UNUSED = 0;
        public final int USED = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class SpFlag
    implements BitSized {
        public final int ASSIGNED = 0;
        public final int AUTOMATIC = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class SpElementFlag
    implements BitSized {
        public final int ELEMENT_UNASSIGNED = 0;
        public final int ELEMENT_ASSIGNED = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static class LevelFlag
    implements BitSized {
        public final int MAX = 0;
        public final int OTHER = 1;

        @Override
        public int BITLEN() {
            return 1;
        }
    }

    public static interface BitSized {
        public int BITLEN();
    }
}

