/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.base.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Base64 {
    private static final String digitsStr = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz+-";
    private static final char[] digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz+-".toCharArray();
    private static final Map<Character, Integer> digitsMap = new HashMap<Character, Integer>();

    public static String fromIntV(int int32) {
        StringBuilder result = new StringBuilder();
        do {
            result.insert(0, digits[int32 & 0x3F]);
        } while ((int32 >>>= 6) != 0);
        return result.toString();
    }

    public static String fromIntN(long int32, int n) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            result.insert(0, digits[(int)(int32 & 0x3FL)]);
            int32 >>>= 6;
        }
        return result.toString();
    }

    public static long toInt(String digitsStr) {
        char[] digits;
        long result = 0L;
        for (char digit : digits = digitsStr.toCharArray()) {
            result = (result << 6) + (long)digitsMap.get(Character.valueOf(digit)).intValue();
        }
        return result;
    }

    public static int toIntSigned(String digitsStr) {
        int result = 0;
        char[] digits = digitsStr.toCharArray();
        if (digits.length > 0 && (digitsMap.get(Character.valueOf(digits[0])) & 0x20) != 0) {
            result = -1;
        }
        for (char digit : digits) {
            result = (result << 6) + digitsMap.get(Character.valueOf(digit));
        }
        return result;
    }

    public static boolean isB64(String string) {
        return Arrays.stream(string.split("")).allMatch(c -> digitsMap.containsKey(Character.valueOf(c.toCharArray()[0])));
    }

    public static boolean isB64CodePoint(int codePoint) {
        boolean isNumber = codePoint > 47 && codePoint < 58;
        boolean isAlphanumLowercase = codePoint > 96 && codePoint < 123;
        boolean isAlphanumUppercase = codePoint > 64 && codePoint < 91;
        boolean isPlusMinus = codePoint == 43 || codePoint == 45;
        return isNumber || isAlphanumLowercase || isAlphanumUppercase || isPlusMinus;
    }

    public static String fromBytes(byte[] arr) {
        StringBuilder b64String = new StringBuilder();
        int rem = 0;
        for (int i = 0; i < arr.length; ++i) {
            int iMod = i % 3;
            int num = (arr[i] & 0xFF) << iMod * 2 & 0x3F | rem;
            rem = (arr[i] & 0xFF) >> 6 - iMod * 2;
            b64String.insert(0, digits[num]);
            if (iMod != 2) continue;
            b64String.insert(0, digits[rem]);
            rem = 0;
        }
        if (arr.length % 3 != 0) {
            b64String.insert(0, digits[rem]);
        }
        return b64String.toString();
    }

    public static byte[] intoBytes(String b64String) {
        byte[] arr = new byte[(int)Math.floor((double)b64String.length() * 0.75)];
        int i = 0;
        int j = b64String.length() - 1;
        while (j > 0) {
            int iMod = i % 3;
            arr[i] = (byte)(Base64.toInt(String.valueOf(b64String.charAt(j))) >>> iMod * 2);
            int n = i;
            arr[n] = (byte)(arr[n] | (byte)(Base64.toInt(String.valueOf(b64String.charAt(j - 1))) << 6 - iMod * 2 & 0xFFL));
            if (iMod == 2) {
                --j;
            }
            --j;
            ++i;
        }
        return arr;
    }

    static {
        for (int i = 0; i < digits.length; ++i) {
            digitsMap.put(Character.valueOf(digits[i]), i);
        }
    }
}

