/*
 * Decompiled with CFR 0.152.
 */
package com.gertoxq.wynnbuild.base.util;

import com.gertoxq.wynnbuild.base.util.Base64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.class_3545;

public class BootstringEncoder {
    private static final List<Character> base = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".chars().mapToObj(c -> Character.valueOf((char)c)).toList();
    private static final Map<Character, Integer> baseMap = new HashMap<Character, Integer>();
    private static final int b = base.size();
    private final int initial_n;
    private final int tmin;
    private final int tmax;
    private final int initial_bias;
    private final int damp;
    private final int skew;
    private final char delimiter;

    public BootstringEncoder(int initial_n, int tmin, int tmax, int initial_bias, int damp, int skew, char delimiter) {
        this.initial_n = initial_n;
        this.tmin = tmin;
        this.tmax = tmax;
        this.initial_bias = initial_bias;
        this.damp = damp;
        this.skew = skew;
        this.delimiter = delimiter;
    }

    private int threshold(int i, int bias) {
        return Math.max(this.tmin, Math.min(b * (i + 1) - bias, this.tmax));
    }

    private class_3545<Integer, String> decodeVLI(String str, int bias) {
        int i = 0;
        int w = 1;
        int res = 0;
        for (int k = 0; k < str.length(); ++k) {
            char char_ = str.charAt(k);
            int d = baseMap.get(Character.valueOf(char_));
            res += d * w;
            int t = this.threshold(i, bias);
            if (d < t) break;
            w *= b - t;
            ++i;
        }
        return new class_3545((Object)res, (Object)str.substring(i + 1));
    }

    private String encodeVLI(int value, int bias) {
        StringBuilder enc = new StringBuilder();
        int i = 0;
        while (true) {
            int t;
            if (value < (t = this.threshold(i, bias))) break;
            enc.append(base.get(t + (value - t) % (b - t)));
            value = (value - t) / (b - t);
            ++i;
        }
        enc.append(base.get(value));
        return enc.toString();
    }

    private int adaptBias(int delta, int length, boolean firstIteration) {
        delta = firstIteration ? Math.floorDiv(delta, this.damp) : delta >> 1;
        delta = Math.floorDiv(delta, length);
        int k = 0;
        int thresh = (b - this.tmin) * this.tmax / 2;
        while (delta > thresh) {
            delta /= b - this.tmin;
            k += b;
        }
        return k + (b - this.tmin + 1) * delta / (delta + this.skew);
    }

    private SplitResult splitBasicExtended(String raw) {
        int codePoint;
        ArrayList<String> basic = new ArrayList<String>();
        TreeSet<Integer> nonBasic = new TreeSet<Integer>();
        for (int i = 0; i < raw.length(); i += Character.charCount(codePoint)) {
            codePoint = raw.codePointAt(i);
            if (Base64.isB64CodePoint(codePoint)) {
                basic.add(String.valueOf((char)codePoint));
                continue;
            }
            nonBasic.add(codePoint);
        }
        int encodedCount = basic.size();
        if (encodedCount > 0) {
            basic.add(String.valueOf(this.delimiter));
        }
        return new SplitResult(basic, nonBasic, encodedCount);
    }

    public String encode(String raw) {
        SplitResult parts = this.splitBasicExtended(raw);
        List<String> basic = parts.basic;
        Set<Integer> nonBasic = parts.nonBasic;
        int encodedCount = parts.encodedCount;
        if (nonBasic.isEmpty()) {
            return String.join((CharSequence)"", basic);
        }
        int delta = 0;
        int n = this.initial_n;
        int bias = this.initial_bias;
        boolean firstIteration = true;
        for (int codepoint : nonBasic) {
            delta += (codepoint - n) * (encodedCount + 1);
            n = codepoint;
            for (int i = 0; i < raw.length(); ++i) {
                String c = String.valueOf(raw.charAt(i));
                int currCodepoint = c.codePointAt(0);
                if (currCodepoint < n || Base64.isB64CodePoint(currCodepoint)) {
                    ++delta;
                }
                if (currCodepoint != n) continue;
                basic.add(this.encodeVLI(delta, bias));
                bias = this.adaptBias(delta, ++encodedCount, firstIteration);
                delta = 0;
                firstIteration = false;
            }
            ++delta;
            ++n;
        }
        return String.join((CharSequence)"", basic);
    }

    public String decode(String bootStr) {
        int delimIdx = bootStr.lastIndexOf(this.delimiter);
        String encodedStr = delimIdx < 0 ? "" : bootStr.substring(0, delimIdx);
        String deltaStr = bootStr.substring(delimIdx + 1);
        List codepoints = encodedStr.codePoints().boxed().collect(Collectors.toList());
        int bias = this.initial_bias;
        int n = this.initial_n;
        int i = 0;
        boolean firstIteration = true;
        while (!deltaStr.isEmpty()) {
            class_3545<Integer, String> p = this.decodeVLI(deltaStr, bias);
            int delta = (Integer)p.method_15442();
            deltaStr = (String)p.method_15441();
            codepoints.add(i %= codepoints.size() + 1, n += (i += delta) / (codepoints.size() + 1));
            bias = this.adaptBias(delta, codepoints.size(), firstIteration);
            firstIteration = false;
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = codepoints.iterator();
        while (iterator.hasNext()) {
            int cp = (Integer)iterator.next();
            sb.append(Character.toChars(cp));
        }
        return sb.toString();
    }

    static {
        for (int i = 0; i < base.size(); ++i) {
            baseMap.put(base.get(i), i);
        }
    }

    private record SplitResult(List<String> basic, Set<Integer> nonBasic, int encodedCount) {
    }
}

