/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation;

import dev.emassey0135.audionavigation.AudioNavigationPlatform;
import dev.emassey0135.audionavigation.config.ServerConfiguration;
import dev.emassey0135.audionavigation.packets.PoiListPayload;
import dev.emassey0135.audionavigation.packets.PoiRequestPayload;
import dev.emassey0135.audionavigation.poi.PoiList;
import dev.emassey0135.audionavigation.util.Database;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Ldev/emassey0135/audionavigation/AudioNavigation;", "", "<init>", "()V", "MOD_ID", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "platform", "Ldev/emassey0135/audionavigation/AudioNavigationPlatform;", "getPlatform", "()Ldev/emassey0135/audionavigation/AudioNavigationPlatform;", "setPlatform", "(Ldev/emassey0135/audionavigation/AudioNavigationPlatform;)V", "config", "Ldev/emassey0135/audionavigation/config/ServerConfiguration;", "getConfig", "()Ldev/emassey0135/audionavigation/config/ServerConfiguration;", "setConfig", "(Ldev/emassey0135/audionavigation/config/ServerConfiguration;)V", "respondToPoiRequest", "Ldev/emassey0135/audionavigation/packets/PoiListPayload;", "world", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "payload", "Ldev/emassey0135/audionavigation/packets/PoiRequestPayload;", "initialize", "", "audioNavigationPlatform", "serverConfig", "audio_navigation-common-paper"})
public final class AudioNavigation {
    @NotNull
    public static final AudioNavigation INSTANCE = new AudioNavigation();
    @NotNull
    public static final String MOD_ID = "audio_navigation";
    @JvmField
    public static final Logger logger = LoggerFactory.getLogger((String)"audio_navigation");
    @Nullable
    private static AudioNavigationPlatform platform;
    @Nullable
    private static ServerConfiguration config;

    private AudioNavigation() {
    }

    @Nullable
    public final AudioNavigationPlatform getPlatform() {
        return platform;
    }

    public final void setPlatform(@Nullable AudioNavigationPlatform audioNavigationPlatform) {
        platform = audioNavigationPlatform;
    }

    @Nullable
    public final ServerConfiguration getConfig() {
        return config;
    }

    public final void setConfig(@Nullable ServerConfiguration serverConfiguration) {
        config = serverConfiguration;
    }

    @NotNull
    public final PoiListPayload respondToPoiRequest(@NotNull ServerLevel world, @NotNull ServerPlayer player, @NotNull PoiRequestPayload payload) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(payload, "payload");
        PoiList poiList = PoiList.Companion.getNearest(world, player, payload.getPoiRequest());
        return new PoiListPayload(payload.getRequestID(), poiList);
    }

    public final void initialize(@NotNull AudioNavigationPlatform audioNavigationPlatform, @NotNull ServerConfiguration serverConfig) {
        Intrinsics.checkNotNullParameter(audioNavigationPlatform, "audioNavigationPlatform");
        Intrinsics.checkNotNullParameter(serverConfig, "serverConfig");
        platform = audioNavigationPlatform;
        config = serverConfig;
        Database.INSTANCE.initialize();
        logger.info("Audio Navigation common has been initialized.");
    }
}

