/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.mixin;

import dev.emassey0135.audionavigation.poi.Features;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={TreeGrower.class})
public class TreeGrowerMixin {
    @Shadow
    @Nullable
    private ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeature(RandomSource random, boolean flowersNearby) {
        throw new AbstractMethodError("Shadow");
    }

    @Shadow
    @Nullable
    private ResourceKey<ConfiguredFeature<?, ?>> getConfiguredMegaFeature(RandomSource random) {
        throw new AbstractMethodError("Shadow");
    }

    @Overwrite
    public boolean growTree(ServerLevel world, ChunkGenerator chunkGenerator, BlockPos pos, BlockState state, RandomSource random) {
        ResourceKey<ConfiguredFeature<?, ?>> resourceKey2;
        Holder holder;
        ResourceKey<ConfiguredFeature<?, ?>> resourceKey = this.getConfiguredMegaFeature(random);
        if (resourceKey != null && (holder = (Holder)world.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(resourceKey).orElse(null)) != null) {
            for (int i = 0; i >= -1; --i) {
                for (int j = 0; j >= -1; --j) {
                    if (!TreeGrowerMixin.isTwoByTwoSapling(state, (BlockGetter)world, pos, i, j)) continue;
                    ConfiguredFeature configuredFeature = (ConfiguredFeature)holder.value();
                    BlockState blockState = Blocks.AIR.defaultBlockState();
                    world.setBlock(pos.offset(i, 0, j), blockState, 260);
                    world.setBlock(pos.offset(i + 1, 0, j), blockState, 260);
                    world.setBlock(pos.offset(i, 0, j + 1), blockState, 260);
                    world.setBlock(pos.offset(i + 1, 0, j + 1), blockState, 260);
                    if (configuredFeature.place((WorldGenLevel)world, chunkGenerator, random, pos.offset(i, 0, j))) {
                        Features.addFeatureToDatabase(resourceKey.location().getPath(), pos.offset(i, 0, j), world);
                        return true;
                    }
                    world.setBlock(pos.offset(i, 0, j), state, 260);
                    world.setBlock(pos.offset(i + 1, 0, j), state, 260);
                    world.setBlock(pos.offset(i, 0, j + 1), state, 260);
                    world.setBlock(pos.offset(i + 1, 0, j + 1), state, 260);
                    return false;
                }
            }
        }
        if ((resourceKey2 = this.getConfiguredFeature(random, this.hasFlowers((LevelAccessor)world, pos))) == null) {
            return false;
        }
        Holder holder2 = world.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(resourceKey2).orElse(null);
        if (holder2 == null) {
            return false;
        }
        ConfiguredFeature configuredFeature2 = (ConfiguredFeature)holder2.value();
        BlockState blockState2 = world.getFluidState(pos).createLegacyBlock();
        world.setBlock(pos, blockState2, 260);
        if (configuredFeature2.place((WorldGenLevel)world, chunkGenerator, random, pos)) {
            if (world.getBlockState(pos) == blockState2) {
                world.sendBlockUpdated(pos, state, blockState2, 2);
            }
            Features.addFeatureToDatabase(resourceKey2.location().getPath(), pos, world);
            return true;
        }
        world.setBlock(pos, state, 260);
        return false;
    }

    @Shadow
    private static boolean isTwoByTwoSapling(BlockState state, BlockGetter world, BlockPos pos, int x, int z) {
        throw new AbstractMethodError("Shadow");
    }

    @Shadow
    private boolean hasFlowers(LevelAccessor world, BlockPos pos) {
        throw new AbstractMethodError("Shadow");
    }
}

