/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.paper;

import dev.emassey0135.audionavigation.AudioNavigation;
import dev.emassey0135.audionavigation.config.ServerConfiguration;
import dev.emassey0135.audionavigation.packets.AddLandmarkPayload;
import dev.emassey0135.audionavigation.packets.DeleteLandmarkPayload;
import dev.emassey0135.audionavigation.packets.PacketIdentifiers;
import dev.emassey0135.audionavigation.packets.PoiListPayload;
import dev.emassey0135.audionavigation.packets.PoiRequestPayload;
import dev.emassey0135.audionavigation.paper.AudioNavigationPlatformImpl;
import dev.emassey0135.audionavigation.poi.Features;
import dev.emassey0135.audionavigation.poi.Landmarks;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Ldev/emassey0135/audionavigation/paper/AudioNavigationPaper;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/plugin/messaging/PluginMessageListener;", "<init>", "()V", "onEnable", "", "onDisable", "onPluginMessageReceived", "channel", "", "player", "Lorg/bukkit/entity/Player;", "message", "", "Companion", "audio_navigation-paper"})
public final class AudioNavigationPaper
extends JavaPlugin
implements PluginMessageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final NamespacedKey WORLD_UUID_KEY = new NamespacedKey("audio_navigation", "world_uuid");

    public void onEnable() {
        FileConfiguration fileConfiguration = this.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        FileConfiguration config = fileConfiguration;
        config.options().copyDefaults(true);
        config.addDefault("restrict-features", (Object)false);
        config.addDefault("allowed-features", CollectionsKt.toList((Iterable)Features.INSTANCE.getFeatures()));
        config.addDefault("radius-limit", (Object)0x4000000);
        boolean bl = config.getBoolean("restrict-features");
        List list = config.getStringList("allowed-features");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        ServerConfiguration serverConfig = new ServerConfiguration(bl, list, config.getInt("radius-limit"));
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, PacketIdentifiers.POI_REQUEST_ID.toString(), (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, PacketIdentifiers.POI_LIST_ID.toString());
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, PacketIdentifiers.ADD_LANDMARK_ID.toString(), (PluginMessageListener)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, PacketIdentifiers.DELETE_LANDMARK_ID.toString(), (PluginMessageListener)this);
        AudioNavigation.INSTANCE.initialize(new AudioNavigationPlatformImpl(), serverConfig);
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.saveConfig();
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(message, "message");
        String string = channel;
        if (Intrinsics.areEqual(string, PacketIdentifiers.POI_REQUEST_ID.toString())) {
            ByteBuf messageBuffer = Unpooled.wrappedBuffer((byte[])message);
            PoiRequestPayload poiRequestPayload = (PoiRequestPayload)PoiRequestPayload.CODEC.decode((Object)messageBuffer);
            World world = player.getWorld();
            Intrinsics.checkNotNull(world, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftWorld");
            ServerLevel world2 = ((CraftWorld)world).getHandle();
            ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            Intrinsics.checkNotNull(world2);
            Intrinsics.checkNotNull(serverPlayer);
            Intrinsics.checkNotNull(poiRequestPayload);
            PoiListPayload poiListPayload = AudioNavigation.INSTANCE.respondToPoiRequest(world2, serverPlayer, poiRequestPayload);
            ByteBuf responseBuffer = Unpooled.buffer();
            PoiListPayload.CODEC.encode((Object)responseBuffer, (Object)poiListPayload);
            byte[] response = new byte[responseBuffer.writerIndex()];
            responseBuffer.getBytes(0, response);
            ((CraftPlayer)player).sendPluginMessage((Plugin)this, PacketIdentifiers.POI_LIST_ID.toString(), response);
        } else if (Intrinsics.areEqual(string, PacketIdentifiers.ADD_LANDMARK_ID.toString())) {
            ByteBuf messageBuffer = Unpooled.wrappedBuffer((byte[])message);
            AddLandmarkPayload addLandmarkPayload = (AddLandmarkPayload)AddLandmarkPayload.CODEC.decode((Object)messageBuffer);
            World world = player.getWorld();
            Intrinsics.checkNotNull(world, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftWorld");
            ServerLevel world3 = ((CraftWorld)world).getHandle();
            ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            Intrinsics.checkNotNull(world3);
            Intrinsics.checkNotNull(serverPlayer);
            Landmarks.INSTANCE.addLandmark(world3, serverPlayer, addLandmarkPayload.getName(), addLandmarkPayload.getPos(), addLandmarkPayload.getVisibleToOtherPlayers());
        } else if (Intrinsics.areEqual(string, PacketIdentifiers.DELETE_LANDMARK_ID.toString())) {
            ByteBuf messageBuffer = Unpooled.wrappedBuffer((byte[])message);
            DeleteLandmarkPayload deleteLandmarkPayload = (DeleteLandmarkPayload)DeleteLandmarkPayload.CODEC.decode((Object)messageBuffer);
            Landmarks.INSTANCE.deleteLandmark(deleteLandmarkPayload.getLandmarkID());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/emassey0135/audionavigation/paper/AudioNavigationPaper$Companion;", "", "<init>", "()V", "WORLD_UUID_KEY", "Lorg/bukkit/NamespacedKey;", "audio_navigation-paper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

