/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.poi;

import dev.emassey0135.audionavigation.poi.Poi;
import dev.emassey0135.audionavigation.poi.PoiData;
import dev.emassey0135.audionavigation.poi.PoiType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0017"}, d2={"Ldev/emassey0135/audionavigation/poi/Features;", "", "<init>", "()V", "features", "", "", "getFeatures", "()Ljava/util/Set;", "redundantFeatures", "duplicateFeatures", "", "getDuplicateFeatures", "()Ljava/util/Map;", "defaultIncludedFeatures", "getDefaultIncludedFeatures", "addFeatureToDatabase", "", "identifier", "pos", "Lnet/minecraft/core/BlockPos;", "world", "Lnet/minecraft/server/level/ServerLevel;", "audio_navigation-common-paper"})
public final class Features {
    @NotNull
    public static final Features INSTANCE = new Features();
    @NotNull
    private static final Set<String> features;
    @NotNull
    private static final Set<String> redundantFeatures;
    @NotNull
    private static final Map<String, String> duplicateFeatures;
    @NotNull
    private static final Set<String> defaultIncludedFeatures;

    private Features() {
    }

    @NotNull
    public final Set<String> getFeatures() {
        return features;
    }

    @NotNull
    public final Map<String, String> getDuplicateFeatures() {
        return duplicateFeatures;
    }

    @NotNull
    public final Set<String> getDefaultIncludedFeatures() {
        return defaultIncludedFeatures;
    }

    @JvmStatic
    public static final void addFeatureToDatabase(@NotNull String identifier, @NotNull BlockPos pos, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(world, "world");
        if (!redundantFeatures.contains(identifier)) {
            String string;
            if (duplicateFeatures.containsKey(identifier)) {
                String string2 = duplicateFeatures.get(identifier);
                Intrinsics.checkNotNull(string2);
                string = string2;
            } else {
                string = identifier;
            }
            String identifier2 = string;
            Optional<PoiData> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, "empty(...)");
            new Poi(PoiType.FEATURE, identifier2, pos, optional).addToDatabase(world);
        }
    }

    static {
        Object[] objectArray = new String[]{"acacia", "amethyst_geode", "azalea_tree", "bamboo_no_podzol", "bamboo_some_podzol", "basalt_blobs", "basalt_pillar", "birch", "birch_leaf_litter", "blackstone_blobs", "blue_ice", "bonus_chest", "cave_vine", "cave_vine_in_moss", "cherry", "chorus_plant", "clay_pool_with_dripleaves", "clay_with_dripleaves", "crimson_forest_vegetation", "crimson_fungus", "dark_oak", "dark_oak_leaf_litter", "delta", "desert_well", "disk_clay", "disk_grass", "disk_gravel", "disk_sand", "dripleaf", "dripstone_cluster", "end_gateway_delayed", "end_gateway_return", "end_island", "end_platform", "end_spike", "fallen_birch_tree", "fallen_jungle_tree", "fallen_oak_tree", "fallen_super_birch_tree", "fallen_spruce_tree", "fancy_oak", "fancy_oak_leaf_litter", "flower_cherry", "flower_default", "flower_flower_forest", "flower_meadow", "flower_pale_garden", "flower_plain", "flower_swamp", "forest_flowers", "forest_rock", "fossil_coal", "fossil_diamonds", "glow_lichen", "glowstone_extra", "huge_brown_mushroom", "huge_red_mushroom", "ice_patch", "ice_spike", "iceberg_blue", "iceberg_packed", "jungle_bush", "jungle_tree", "jungle_tree_no_vine", "kelp", "lake_lava", "large_basalt_columns", "large_dripstone", "mangrove", "mega_jungle_tree", "mega_pine", "mega_spruce", "monster_room", "moss_patch", "moss_patch_ceiling", "moss_vegetation", "nether_sprouts", "oak", "oak_leaf_litter", "ore_ancient_debris_large", "ore_ancient_debris_small", "ore_andesite", "ore_blackstone", "ore_clay", "ore_coal", "ore_coal_buried", "ore_copper_large", "ore_copper_small", "ore_diamond_buried", "ore_diamond_large", "ore_diamond_medium", "ore_diamond_small", "ore_diorite", "ore_dirt", "ore_emerald", "ore_gold", "ore_gold_buried", "ore_granite", "ore_gravel", "ore_gravel_nether", "ore_infested", "ore_iron", "ore_iron_small", "ore_lapis", "ore_lapis_buried", "ore_magma", "ore_nether_gold", "ore_quartz", "ore_redstone", "ore_soul_sand", "ore_tuff", "pale_forest_flowers", "pale_moss_patch", "pale_moss_vegetation", "pale_oak", "pale_oak_creaking", "patch_berry_bush", "patch_brown_mushroom", "patch_cactus", "patch_crimson_roots", "patch_dead_bush", "patch_fire", "patch_firefly_bush", "patch_grass", "patch_grass_jungle", "patch_large_fern", "patch_leaf_litter", "patch_melon", "patch_pumpkin", "patch_red_mushroom", "patch_soul_fire", "patch_sugar_cane", "patch_sunflower", "patch_taiga_grass", "patch_tall_grass", "patch_waterlily", "pile_hay", "pile_ice", "pile_melon", "pile_pumpkin", "pile_snow", "pine", "pointed_dripstone", "rooted_azalea_tree", "sculk_patch_ancient_city", "sculk_patch_deep_dark", "sculk_vein", "sea_pickle", "seagrass_mid", "seagrass_short", "seagrass_slightly_less_short", "seagrass_tall", "single_piece_of_grass", "small_basalt_columns", "spore_blossom", "spring_lava_frozen", "spring_lava_nether", "spring_lava_overworld", "spring_nether_closed", "spring_nether_open", "spring_water", "spruce", "super_birch", "swamp_oak", "tall_mangrove", "twisting_vines", "underwater_magma", "vines", "void_start_platform", "warm_ocean_vegetation", "warped_forest_vegetation", "warped_fungus", "weeping_vines", "wildflowers_birch_forest", "wildflowers_meadow"};
        features = SetsKt.setOf(objectArray);
        objectArray = new String[]{"bamboo_vegetation", "birch_tall", "dark_forest_vegetation", "freeze_top_layer", "lush_caves_clay", "mangrove_vegetation", "meadow_trees", "mushroom_island_vegetation", "pale_garden_vegetation", "trees_badlands", "trees_birch", "trees_birch_and_oak", "trees_birch_and_oak_leaf_litter", "trees_flower_forest", "trees_grove", "trees_jungle", "trees_old_growth_pine_taiga", "trees_old_growth_spruce_taiga", "trees_plains", "trees_savanna", "trees_snowy", "trees_sparse_jungle", "trees_taiga", "trees_water", "trees_windswept_hills"};
        redundantFeatures = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to("birch_bees_0002", "birch"), TuplesKt.to("birch_bees_0002_leaf_litter", "birch_leaf_litter"), TuplesKt.to("birch_bees_002", "birch"), TuplesKt.to("birch_bees_005", "birch"), TuplesKt.to("cherry_bees_005", "cherry"), TuplesKt.to("crimson_forest_vegetation_bonemeal", "crimson_forest_vegetation"), TuplesKt.to("crimson_fungus_planted", "crimson_fungus"), TuplesKt.to("fancy_oak_bees", "fancy_oak"), TuplesKt.to("fancy_oak_bees_0002", "fancy_oak"), TuplesKt.to("fancy_oak_bees_0002_leaf_litter", "fancy_oak_leaf_litter"), TuplesKt.to("fancy_oak_bees_002", "fancy_oak"), TuplesKt.to("fancy_oak_bees_005", "fancy_oak"), TuplesKt.to("moss_patch_bonemeal", "moss_patch"), TuplesKt.to("nether_sprouts_bonemeal", "nether_sprouts"), TuplesKt.to("oak_bees_0002", "oak"), TuplesKt.to("oak_bees_0002_leaf_litter", "oak_leaf_litter"), TuplesKt.to("oak_bees_002", "oak"), TuplesKt.to("oak_bees_005", "oak"), TuplesKt.to("pale_moss_patch_bonemeal", "pale_moss_patch"), TuplesKt.to("pale_oak_bonemeal", "pale_oak"), TuplesKt.to("super_birch_bees", "super_birch"), TuplesKt.to("super_birch_bees_0002", "super_birch"), TuplesKt.to("twisting_vines_bonemeal", "twisting_vines"), TuplesKt.to("warped_forest_vegetation_bonemeal", "warped_forest_vegetation"), TuplesKt.to("warped_fungus_planted", "warped_fungus")};
        duplicateFeatures = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"acacia", "amethyst_geode", "azalea_tree", "bamboo_no_podzol", "bamboo_some_podzol", "basalt_pillar", "birch", "birch_leaf_litter", "bonus_chest", "cherry", "chorus_plant", "clay_pool_with_dripleaves", "clay_with_dripleaves", "crimson_forest_vegetation", "crimson_fungus", "dark_oak", "dark_oak_leaf_litter", "delta", "desert_well", "dripleaf", "dripstone_cluster", "end_gateway_delayed", "end_gateway_return", "end_island", "end_platform", "end_spike", "fallen_birch_tree", "fallen_jungle_tree", "fallen_oak_tree", "fallen_super_birch_tree", "fallen_spruce_tree", "fancy_oak", "fancy_oak_leaf_litter", "forest_rock", "fossil_coal", "fossil_diamonds", "glowstone_extra", "huge_brown_mushroom", "huge_red_mushroom", "ice_spike", "iceberg_blue", "iceberg_packed", "jungle_bush", "jungle_tree", "jungle_tree_no_vine", "lake_lava", "large_basalt_columns", "large_dripstone", "mangrove", "mega_jungle_tree", "mega_pine", "mega_spruce", "nether_sprouts", "oak", "oak_leaf_litter", "pale_oak", "patch_berry_bush", "patch_brown_mushroom", "patch_cactus", "patch_crimson_roots", "patch_fire", "patch_firefly_bush", "patch_leaf_litter", "patch_melon", "patch_pumpkin", "patch_red_mushroom", "patch_soul_fire", "patch_sugar_cane", "pile_hay", "pile_ice", "pile_melon", "pile_pumpkin", "pile_snow", "pine", "pointed_dripstone", "rooted_azalea_tree", "sculk_patch_ancient_city", "sculk_patch_deep_dark", "sculk_vein", "sea_pickle", "small_basalt_columns", "spore_blossom", "spring_lava_frozen", "spring_lava_nether", "spring_lava_overworld", "spring_nether_closed", "spring_nether_open", "spring_water", "spruce", "super_birch", "swamp_oak", "tall_mangrove", "underwater_magma", "void_start_platform", "warped_forest_vegetation", "warped_fungus"};
        defaultIncludedFeatures = SetsKt.setOf(objectArray);
    }
}

