/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.poi;

import dev.emassey0135.audionavigation.poi.Poi;
import dev.emassey0135.audionavigation.poi.PoiData;
import dev.emassey0135.audionavigation.poi.PoiType;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Ldev/emassey0135/audionavigation/poi/Landmarks;", "", "<init>", "()V", "addLandmark", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "name", "", "pos", "Lnet/minecraft/core/BlockPos;", "visibleToOtherPlayers", "", "deleteLandmark", "id", "", "audio_navigation-common-paper"})
public final class Landmarks {
    @NotNull
    public static final Landmarks INSTANCE = new Landmarks();

    private Landmarks() {
    }

    public final void addLandmark(@NotNull ServerLevel world, @NotNull ServerPlayer player, @NotNull String name, @NotNull BlockPos pos, boolean visibleToOtherPlayers) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(pos, "pos");
        PoiData data = new PoiData(player.getUUID(), visibleToOtherPlayers);
        Optional<PoiData> optional = Optional.of(data);
        Intrinsics.checkNotNullExpressionValue(optional, "of(...)");
        new Poi(PoiType.LANDMARK, name, pos, optional).addToDatabase(world);
    }

    public final void deleteLandmark(int id) {
        Poi.Companion.deleteLandmark(id);
    }
}

