/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.poi;

import dev.emassey0135.audionavigation.AudioNavigation;
import dev.emassey0135.audionavigation.AudioNavigationPlatform;
import dev.emassey0135.audionavigation.poi.Poi;
import dev.emassey0135.audionavigation.poi.PoiData;
import dev.emassey0135.audionavigation.poi.PoiType;
import dev.emassey0135.audionavigation.util.Database;
import io.netty.buffer.ByteBuf;
import java.sql.PreparedStatement;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Ldev/emassey0135/audionavigation/poi/Poi;", "", "type", "Ldev/emassey0135/audionavigation/poi/PoiType;", "name", "", "pos", "Lnet/minecraft/core/BlockPos;", "data", "Ljava/util/Optional;", "Ldev/emassey0135/audionavigation/poi/PoiData;", "<init>", "(Ldev/emassey0135/audionavigation/poi/PoiType;Ljava/lang/String;Lnet/minecraft/core/BlockPos;Ljava/util/Optional;)V", "getType", "()Ldev/emassey0135/audionavigation/poi/PoiType;", "getName", "()Ljava/lang/String;", "getPos", "()Lnet/minecraft/core/BlockPos;", "getData", "()Ljava/util/Optional;", "distance", "", "pos2", "poi", "addToDatabase", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "audio_navigation-common-paper"})
@SourceDebugExtension(value={"SMAP\nPoi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poi.kt\ndev/emassey0135/audionavigation/poi/Poi\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,81:1\n186#2:82\n*S KotlinDebug\n*F\n+ 1 Poi.kt\ndev/emassey0135/audionavigation/poi/Poi\n*L\n52#1:82\n*E\n"})
public final class Poi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PoiType type;
    @NotNull
    private final String name;
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final Optional<PoiData> data;
    @Nullable
    private static PreparedStatement addToDatabaseStatement;
    @NotNull
    private static final ReentrantLock addToDatabaseMutex;
    @Nullable
    private static PreparedStatement deleteLandmarkStatement;
    @NotNull
    private static final ReentrantLock deleteLandmarkMutex;
    @JvmField
    public static final StreamCodec<ByteBuf, Poi> STREAM_CODEC;

    public Poi(@NotNull PoiType type, @NotNull String name, @NotNull BlockPos pos, @NotNull Optional<PoiData> data) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(data, "data");
        this.type = type;
        this.name = name;
        this.pos = pos;
        this.data = data;
    }

    @NotNull
    public final PoiType getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final Optional<PoiData> getData() {
        return this.data;
    }

    public final double distance(@NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter(pos2, "pos2");
        double x = this.pos.getX();
        double x2 = pos2.getX();
        double y = this.pos.getY();
        double y2 = pos2.getY();
        double z = this.pos.getZ();
        double z2 = pos2.getZ();
        return Math.sqrt(Math.pow(x - x2, 2) + Math.pow(y - y2, 2) + Math.pow(z - z2, 2));
    }

    public final double distance(@NotNull Poi poi) {
        Intrinsics.checkNotNullParameter(poi, "poi");
        return this.distance(poi.pos);
    }

    /*
     * WARNING - void declaration
     */
    public final void addToDatabase(@NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter(world, "world");
        addToDatabaseMutex.lock();
        if (addToDatabaseStatement == null) {
            addToDatabaseStatement = Database.connection.prepareStatement("INSERT INTO pois2 (id, minX, maxX, minY, maxY, minZ, maxZ, world, type, name, data, x, y, z) VALUES(NULL, ?1, ?1, ?2, ?2, ?3, ?3, ?6, ?4, ?5, ?7, ?1, ?2, ?3)");
        }
        PreparedStatement preparedStatement = addToDatabaseStatement;
        if (preparedStatement != null) {
            preparedStatement.setInt(1, this.pos.getX());
        }
        PreparedStatement preparedStatement2 = addToDatabaseStatement;
        if (preparedStatement2 != null) {
            preparedStatement2.setInt(2, this.pos.getY());
        }
        PreparedStatement preparedStatement3 = addToDatabaseStatement;
        if (preparedStatement3 != null) {
            preparedStatement3.setInt(3, this.pos.getZ());
        }
        PreparedStatement preparedStatement4 = addToDatabaseStatement;
        if (preparedStatement4 != null) {
            preparedStatement4.setInt(4, this.type.ordinal());
        }
        PreparedStatement preparedStatement5 = addToDatabaseStatement;
        if (preparedStatement5 != null) {
            preparedStatement5.setString(5, this.name);
        }
        PreparedStatement preparedStatement6 = addToDatabaseStatement;
        if (preparedStatement6 != null) {
            AudioNavigationPlatform audioNavigationPlatform = AudioNavigation.INSTANCE.getPlatform();
            Intrinsics.checkNotNull(audioNavigationPlatform);
            preparedStatement6.setBytes(6, UUIDUtil.uuidToByteArray((UUID)audioNavigationPlatform.getWorldUUID(world)));
        }
        if (this.data.isPresent()) {
            PreparedStatement preparedStatement7 = addToDatabaseStatement;
            if (preparedStatement7 != null) {
                void $this$encodeToByteArray$iv;
                BinaryFormat binaryFormat = ProtoBuf.Default;
                PoiData value$iv = this.data.get();
                boolean $i$f$encodeToByteArray = false;
                $this$encodeToByteArray$iv.getSerializersModule();
                preparedStatement7.setBytes(7, $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)PoiData.Companion.serializer(), value$iv));
            }
        } else {
            PreparedStatement preparedStatement8 = addToDatabaseStatement;
            if (preparedStatement8 != null) {
                preparedStatement8.setNull(7, 0);
            }
        }
        PreparedStatement preparedStatement9 = addToDatabaseStatement;
        if (preparedStatement9 != null) {
            preparedStatement9.executeUpdate();
        }
        addToDatabaseMutex.unlock();
        Database.INSTANCE.scheduleCommitIfNeeded();
    }

    @NotNull
    public final PoiType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final BlockPos component3() {
        return this.pos;
    }

    @NotNull
    public final Optional<PoiData> component4() {
        return this.data;
    }

    @NotNull
    public final Poi copy(@NotNull PoiType type, @NotNull String name, @NotNull BlockPos pos, @NotNull Optional<PoiData> data) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(data, "data");
        return new Poi(type, name, pos, data);
    }

    public static /* synthetic */ Poi copy$default(Poi poi, PoiType poiType, String string, BlockPos blockPos, Optional optional, int n, Object object) {
        if ((n & 1) != 0) {
            poiType = poi.type;
        }
        if ((n & 2) != 0) {
            string = poi.name;
        }
        if ((n & 4) != 0) {
            blockPos = poi.pos;
        }
        if ((n & 8) != 0) {
            optional = poi.data;
        }
        return poi.copy(poiType, string, blockPos, optional);
    }

    @NotNull
    public String toString() {
        return "Poi(type=" + this.type + ", name=" + this.name + ", pos=" + this.pos + ", data=" + this.data + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.pos.hashCode();
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Poi)) {
            return false;
        }
        Poi poi = (Poi)other;
        if (this.type != poi.type) {
            return false;
        }
        if (!Intrinsics.areEqual(this.name, poi.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pos, poi.pos)) {
            return false;
        }
        return Intrinsics.areEqual(this.data, poi.data);
    }

    private static final PoiType STREAM_CODEC$lambda$0(KProperty1 $tmp0, Poi p0) {
        return (PoiType)((Object)((Function1)$tmp0).invoke(p0));
    }

    private static final String STREAM_CODEC$lambda$1(KProperty1 $tmp0, Poi p0) {
        return (String)((Function1)$tmp0).invoke(p0);
    }

    private static final BlockPos STREAM_CODEC$lambda$2(KProperty1 $tmp0, Poi p0) {
        return (BlockPos)((Function1)$tmp0).invoke(p0);
    }

    private static final Optional STREAM_CODEC$lambda$3(KProperty1 $tmp0, Poi p0) {
        return (Optional)((Function1)$tmp0).invoke(p0);
    }

    static {
        addToDatabaseMutex = new ReentrantLock();
        deleteLandmarkMutex = new ReentrantLock();
        STREAM_CODEC = StreamCodec.composite(PoiType.STREAM_CODEC, arg_0 -> Poi.STREAM_CODEC$lambda$0(Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.STRING_UTF8, arg_0 -> Poi.STREAM_CODEC$lambda$1(Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)BlockPos.STREAM_CODEC, arg_0 -> Poi.STREAM_CODEC$lambda$2(Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.optional(PoiData.STREAM_CODEC), arg_0 -> Poi.STREAM_CODEC$lambda$3(Companion.STREAM_CODEC.4.INSTANCE, arg_0), Poi::new);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u000e\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000f0\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/emassey0135/audionavigation/poi/Poi$Companion;", "", "<init>", "()V", "addToDatabaseStatement", "Ljava/sql/PreparedStatement;", "addToDatabaseMutex", "Ljava/util/concurrent/locks/ReentrantLock;", "deleteLandmarkStatement", "deleteLandmarkMutex", "deleteLandmark", "", "id", "", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "Ldev/emassey0135/audionavigation/poi/Poi;", "audio_navigation-common-paper"})
    public static final class Companion {
        private Companion() {
        }

        public final void deleteLandmark(int id) {
            deleteLandmarkMutex.lock();
            if (deleteLandmarkStatement == null) {
                deleteLandmarkStatement = Database.connection.prepareStatement("DELETE FROM pois2 WHERE id = ?1");
            }
            PreparedStatement preparedStatement = deleteLandmarkStatement;
            if (preparedStatement != null) {
                preparedStatement.setInt(1, id);
            }
            PreparedStatement preparedStatement2 = deleteLandmarkStatement;
            if (preparedStatement2 != null) {
                preparedStatement2.executeUpdate();
            }
            deleteLandmarkMutex.unlock();
            Database.INSTANCE.scheduleCommitIfNeeded();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

