/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.poi;

import dev.emassey0135.audionavigation.AudioNavigation;
import dev.emassey0135.audionavigation.AudioNavigationPlatform;
import dev.emassey0135.audionavigation.config.ServerConfiguration;
import dev.emassey0135.audionavigation.poi.Poi;
import dev.emassey0135.audionavigation.poi.PoiData;
import dev.emassey0135.audionavigation.poi.PoiListItem;
import dev.emassey0135.audionavigation.poi.PoiRequest;
import dev.emassey0135.audionavigation.poi.PoiType;
import dev.emassey0135.audionavigation.util.Database;
import io.netty.buffer.ByteBuf;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/emassey0135/audionavigation/poi/PoiList;", "", "list", "", "Ldev/emassey0135/audionavigation/poi/PoiListItem;", "<init>", "(Ljava/util/List;)V", "()V", "poiList", "", "toList", "addPoi", "", "poi", "Ldev/emassey0135/audionavigation/poi/Poi;", "distance", "", "id", "", "delete", "subtract", "poiList2", "Companion", "audio_navigation-common-paper"})
@SourceDebugExtension(value={"SMAP\nPoiList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoiList.kt\ndev/emassey0135/audionavigation/poi/PoiList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n774#2:119\n865#2,2:120\n*S KotlinDebug\n*F\n+ 1 PoiList.kt\ndev/emassey0135/audionavigation/poi/PoiList\n*L\n49#1:119\n49#1:120,2\n*E\n"})
public final class PoiList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PoiListItem> poiList;
    @Nullable
    private static PoiRequest currentPoiRequest;
    @Nullable
    private static UUID currentPlayerUUID;
    @Nullable
    private static PreparedStatement getNearestStatement;
    @NotNull
    private static final ReentrantLock getNearestMutex;
    @JvmField
    public static final StreamCodec<ByteBuf, PoiList> STREAM_CODEC;

    public PoiList(@NotNull List<PoiListItem> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        this.poiList = CollectionsKt.toMutableList((Collection)list);
    }

    public PoiList() {
        this(CollectionsKt.emptyList());
    }

    @NotNull
    public final List<PoiListItem> toList() {
        return CollectionsKt.toList((Iterable)this.poiList);
    }

    public final void addPoi(@NotNull PoiListItem poi) {
        Intrinsics.checkNotNullParameter(poi, "poi");
        this.poiList.add(poi);
    }

    public final void addPoi(@NotNull Poi poi, double distance, int id) {
        Intrinsics.checkNotNullParameter(poi, "poi");
        this.poiList.add(new PoiListItem(poi, distance, id));
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(int id) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.poiList;
        List<PoiListItem> list = this.poiList;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PoiListItem poi = (PoiListItem)element$iv$iv;
            boolean bl = false;
            if (!(poi.getId() == id)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.removeAll((List)destination$iv$iv);
    }

    @NotNull
    public final PoiList subtract(@NotNull PoiList poiList2) {
        Intrinsics.checkNotNullParameter(poiList2, "poiList2");
        return new PoiList(CollectionsKt.minus((Iterable)this.poiList, (Iterable)poiList2.toList()));
    }

    static {
        getNearestMutex = new ReentrantLock();
        STREAM_CODEC = StreamCodec.composite((StreamCodec)PoiListItem.STREAM_CODEC.apply(ByteBufCodecs.list()), PoiList::toList, PoiList::new);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 RP\u0010'\u001aB\u0012\f\u0012\n **\u0004\u0018\u00010)0)\u0012\f\u0012\n **\u0004\u0018\u00010\u00150\u0015 ** \u0012\f\u0012\n **\u0004\u0018\u00010)0)\u0012\f\u0012\n **\u0004\u0018\u00010\u00150\u0015\u0018\u00010(0(8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/emassey0135/audionavigation/poi/PoiList$Companion;", "", "<init>", "()V", "currentPoiRequest", "Ldev/emassey0135/audionavigation/poi/PoiRequest;", "getCurrentPoiRequest", "()Ldev/emassey0135/audionavigation/poi/PoiRequest;", "setCurrentPoiRequest", "(Ldev/emassey0135/audionavigation/poi/PoiRequest;)V", "currentPlayerUUID", "Ljava/util/UUID;", "getCurrentPlayerUUID", "()Ljava/util/UUID;", "setCurrentPlayerUUID", "(Ljava/util/UUID;)V", "filterPoi", "", "poi", "Ldev/emassey0135/audionavigation/poi/Poi;", "getFromDatabase", "Ldev/emassey0135/audionavigation/poi/PoiList;", "query", "Ljava/sql/PreparedStatement;", "getNearestStatement", "getGetNearestStatement", "()Ljava/sql/PreparedStatement;", "setGetNearestStatement", "(Ljava/sql/PreparedStatement;)V", "getNearestMutex", "Ljava/util/concurrent/locks/ReentrantLock;", "getGetNearestMutex", "()Ljava/util/concurrent/locks/ReentrantLock;", "getNearest", "world", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "poiRequest", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "audio_navigation-common-paper"})
    @SourceDebugExtension(value={"SMAP\nPoiList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoiList.kt\ndev/emassey0135/audionavigation/poi/PoiList$Companion\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,118:1\n196#2:119\n*S KotlinDebug\n*F\n+ 1 PoiList.kt\ndev/emassey0135/audionavigation/poi/PoiList$Companion\n*L\n87#1:119\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PoiRequest getCurrentPoiRequest() {
            return currentPoiRequest;
        }

        public final void setCurrentPoiRequest(@Nullable PoiRequest poiRequest) {
            currentPoiRequest = poiRequest;
        }

        @Nullable
        public final UUID getCurrentPlayerUUID() {
            return currentPlayerUUID;
        }

        public final void setCurrentPlayerUUID(@Nullable UUID uUID) {
            currentPlayerUUID = uUID;
        }

        public final double filterPoi(@NotNull Poi poi) {
            Intrinsics.checkNotNullParameter(poi, "poi");
            PoiRequest poiRequest = this.getCurrentPoiRequest();
            Intrinsics.checkNotNull(poiRequest);
            BlockPos pos = poiRequest.getPos();
            PoiRequest poiRequest2 = this.getCurrentPoiRequest();
            Intrinsics.checkNotNull(poiRequest2);
            int radius = poiRequest2.getRadius();
            PoiRequest poiRequest3 = this.getCurrentPoiRequest();
            Intrinsics.checkNotNull(poiRequest3);
            Optional<Integer> verticalLimit = poiRequest3.getVerticalLimit();
            PoiRequest poiRequest4 = this.getCurrentPoiRequest();
            Intrinsics.checkNotNull(poiRequest4);
            Optional<PoiType> type = poiRequest4.getType();
            PoiRequest poiRequest5 = this.getCurrentPoiRequest();
            Intrinsics.checkNotNull(poiRequest5);
            Optional<List<String>> includedFeatures = poiRequest5.getIncludedFeatures();
            double distance = poi.distance(pos);
            ServerConfiguration serverConfiguration = AudioNavigation.INSTANCE.getConfig();
            Intrinsics.checkNotNull(serverConfiguration);
            ServerConfiguration config = serverConfiguration;
            return type.isPresent() && poi.getType() != type.get() ? -1.0 : (distance > (double)radius ? -1.0 : (distance > (double)config.getRadiusLimit() ? -1.0 : (verticalLimit.isPresent() && Math.abs(poi.getPos().getY() - pos.getY()) > ((Number)verticalLimit.get()).intValue() ? -1.0 : (poi.getType() == PoiType.LANDMARK && poi.getData().isPresent() && !poi.getData().get().getVisibleToOtherPlayers() && !Intrinsics.areEqual(poi.getData().get().getPlayer(), this.getCurrentPlayerUUID()) ? -1.0 : (includedFeatures.isPresent() && poi.getType() == PoiType.FEATURE && !includedFeatures.get().contains(poi.getName()) ? -1.0 : (config.getRestrictFeatures() && poi.getType() == PoiType.FEATURE && !config.getAllowedFeatures().contains(poi.getName()) ? -1.0 : distance))))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final PoiList getFromDatabase(PreparedStatement query) {
            PoiList poiList = new PoiList();
            AutoCloseable autoCloseable = query.executeQuery();
            Throwable throwable = null;
            try {
                ResultSet it = (ResultSet)autoCloseable;
                boolean bl = false;
                while (it.next()) {
                    Optional<PoiData> data;
                    PoiType type = (PoiType)((Object)PoiType.getEntries().get(it.getInt("type")));
                    String name = it.getString("name");
                    BlockPos pos = new BlockPos(it.getInt("x"), it.getInt("y"), it.getInt("z"));
                    byte[] dataBinary = it.getBytes("data");
                    Intrinsics.checkNotNullExpressionValue(Optional.empty(), "empty(...)");
                    if (dataBinary != null) {
                        void $this$decodeFromByteArray$iv;
                        BinaryFormat binaryFormat = ProtoBuf.Default;
                        byte[] bytes$iv = dataBinary;
                        boolean $i$f$decodeFromByteArray = false;
                        $this$decodeFromByteArray$iv.getSerializersModule();
                        Optional optional = Optional.of($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)PoiData.Companion.serializer(), bytes$iv));
                        Intrinsics.checkNotNullExpressionValue(optional, "of(...)");
                        data = optional;
                    }
                    double distance = it.getDouble("distance");
                    int id = it.getInt("id");
                    Intrinsics.checkNotNull(name);
                    poiList.addPoi(new Poi(type, name, pos, data), distance, id);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            return poiList;
        }

        @Nullable
        public final PreparedStatement getGetNearestStatement() {
            return getNearestStatement;
        }

        public final void setGetNearestStatement(@Nullable PreparedStatement preparedStatement) {
            getNearestStatement = preparedStatement;
        }

        @NotNull
        public final ReentrantLock getGetNearestMutex() {
            return getNearestMutex;
        }

        @NotNull
        public final PoiList getNearest(@NotNull ServerLevel world, @NotNull ServerPlayer player, @NotNull PoiRequest poiRequest) {
            Intrinsics.checkNotNullParameter(world, "world");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(poiRequest, "poiRequest");
            this.getGetNearestMutex().lock();
            this.setCurrentPoiRequest(poiRequest);
            this.setCurrentPlayerUUID(player.getUUID());
            if (this.getGetNearestStatement() == null) {
                this.setGetNearestStatement(Database.connection.prepareStatement("SELECT id, type, name, data, x, y, z, filterPoi(type, name, x, y, z, data) AS distance FROM pois2 WHERE distance >= 0 AND world = ?6 AND minX >= ?1-?4 AND maxX <= ?1+?4 AND minY >= ?2-?4 AND maxY <= ?2+?4 AND minZ >= ?3-?4 AND maxZ <= ?3+?4 ORDER BY distance LIMIT ?5"));
            }
            PreparedStatement preparedStatement = this.getGetNearestStatement();
            if (preparedStatement != null) {
                preparedStatement.setInt(1, poiRequest.getPos().getX());
            }
            PreparedStatement preparedStatement2 = this.getGetNearestStatement();
            if (preparedStatement2 != null) {
                preparedStatement2.setInt(2, poiRequest.getPos().getY());
            }
            PreparedStatement preparedStatement3 = this.getGetNearestStatement();
            if (preparedStatement3 != null) {
                preparedStatement3.setInt(3, poiRequest.getPos().getZ());
            }
            PreparedStatement preparedStatement4 = this.getGetNearestStatement();
            if (preparedStatement4 != null) {
                preparedStatement4.setInt(4, poiRequest.getRadius());
            }
            PreparedStatement preparedStatement5 = this.getGetNearestStatement();
            if (preparedStatement5 != null) {
                preparedStatement5.setInt(5, poiRequest.getMaxItems());
            }
            PreparedStatement preparedStatement6 = this.getGetNearestStatement();
            if (preparedStatement6 != null) {
                AudioNavigationPlatform audioNavigationPlatform = AudioNavigation.INSTANCE.getPlatform();
                Intrinsics.checkNotNull(audioNavigationPlatform);
                preparedStatement6.setBytes(6, UUIDUtil.uuidToByteArray((UUID)audioNavigationPlatform.getWorldUUID(world)));
            }
            PreparedStatement preparedStatement7 = this.getGetNearestStatement();
            Intrinsics.checkNotNull(preparedStatement7);
            PoiList result = this.getFromDatabase(preparedStatement7);
            this.getGetNearestMutex().unlock();
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

