/*
 * Decompiled with CFR 0.152.
 */
package dev.emassey0135.audionavigation.util;

import dev.emassey0135.audionavigation.AudioNavigation;
import dev.emassey0135.audionavigation.poi.Poi;
import dev.emassey0135.audionavigation.poi.PoiData;
import dev.emassey0135.audionavigation.poi.PoiList;
import dev.emassey0135.audionavigation.poi.PoiType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.sqlite.Function;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/emassey0135/audionavigation/util/Database;", "", "<init>", "()V", "connection", "Ljava/sql/Connection;", "kotlin.jvm.PlatformType", "commitScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduleCommitIfNeeded", "", "initialize", "FilterPoiFunction", "audio_navigation-common-paper"})
@SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\ndev/emassey0135/audionavigation/util/Database\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class Database {
    @NotNull
    public static final Database INSTANCE = new Database();
    @JvmField
    public static final Connection connection = DriverManager.getConnection("jdbc:sqlite:poi.db");
    @NotNull
    private static AtomicBoolean commitScheduled = new AtomicBoolean();

    private Database() {
    }

    public final void scheduleCommitIfNeeded() {
        if (commitScheduled.compareAndSet(false, true)) {
            ThreadsKt.thread$default(false, false, null, null, 0, Database::scheduleCommitIfNeeded$lambda$0, 31, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            boolean bl;
            Statement it = (Statement)autoCloseable;
            boolean bl2 = false;
            it.execute("CREATE VIRTUAL TABLE IF NOT EXISTS pois2 USING RTREE_I32(id, minX, maxX, minY, maxY, minZ, maxZ, +world BLOB, +type INTEGER, +name TEXT, +data BLOB, +x INTEGER, +y INTEGER, +z INTEGER)");
            AutoCloseable autoCloseable2 = it.executeQuery("SELECT name FROM sqlite_master WHERE type = 'table' AND name = 'pois'");
            Throwable throwable2 = null;
            try {
                ResultSet it2 = (ResultSet)autoCloseable2;
                boolean bl3 = false;
                bl = it2.next();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            if (bl) {
                AudioNavigation.logger.info("Migrating database to schema version 2. This may take a few minutes.");
                it.executeUpdate("INSERT INTO pois2 (id, minX, maxX, minY, maxY, minZ, maxZ, world, type, name, data, x, y, z) SELECT id, minX, maxX, minY, maxY, minZ, maxZ, world, type, name, NULL, x, y, z FROM pois");
                it.execute("DROP TABLE pois");
                it.execute("VACUUM");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Function.create((Connection)connection, (String)"filterPoi", (Function)new FilterPoiFunction(), (int)6, (int)2048);
        connection.setAutoCommit(false);
        AudioNavigation.logger.info("Database initialized.");
    }

    private static final Unit scheduleCommitIfNeeded$lambda$0() {
        Thread.sleep(1000L);
        commitScheduled.set(false);
        connection.commit();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Ldev/emassey0135/audionavigation/util/Database$FilterPoiFunction;", "Lorg/sqlite/Function;", "<init>", "()V", "xFunc", "", "audio_navigation-common-paper"})
    @SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\ndev/emassey0135/audionavigation/util/Database$FilterPoiFunction\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,63:1\n196#2:64\n*S KotlinDebug\n*F\n+ 1 Database.kt\ndev/emassey0135/audionavigation/util/Database$FilterPoiFunction\n*L\n44#1:64\n*E\n"})
    public static final class FilterPoiFunction
    extends Function {
        /*
         * WARNING - void declaration
         */
        protected void xFunc() {
            if (this.args() != 6) {
                this.error("Invalid number of arguments passed to filterPoi function");
            }
            PoiType type = (PoiType)((Object)PoiType.getEntries().get(this.value_int(0)));
            String name = this.value_text(1);
            int x = (int)this.value_double(2);
            int y = (int)this.value_double(3);
            int z = (int)this.value_double(4);
            byte[] dataBinary = this.value_blob(5);
            Optional<PoiData> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, "empty(...)");
            Optional<PoiData> data = optional;
            if (dataBinary != null) {
                void $this$decodeFromByteArray$iv;
                BinaryFormat binaryFormat = ProtoBuf.Default;
                byte[] bytes$iv = dataBinary;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                Optional optional2 = Optional.of($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)PoiData.Companion.serializer(), bytes$iv));
                Intrinsics.checkNotNullExpressionValue(optional2, "of(...)");
                data = optional2;
            }
            Intrinsics.checkNotNull(name);
            this.result(PoiList.Companion.filterPoi(new Poi(type, name, new BlockPos(x, y, z), data)));
        }
    }
}

