/*
 * Decompiled with CFR 0.152.
 */
package cn.moerain.linuxssh;

import cn.moerain.linuxssh.Linuxssh;
import cn.moerain.linuxssh.config.LinuxsshConfig;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0014\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u001d\u0010\u001a\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0017J\u001d\u0010\u001b\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0017J\u001d\u0010\u001c\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0017R \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R,\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\"0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010!R,\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\"0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010!R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010'\u00a8\u0006)"}, d2={"Lcn/moerain/linuxssh/Linuxssh;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "", "host", "", "deleteHostFingerprint", "(Ljava/lang/String;)Z", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "registerSshCommand", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "confirmed", "", "handleFingerprintConfirmation", "(Lcom/mojang/brigadier/context/CommandContext;Z)I", "handleDisconnect", "(Lcom/mojang/brigadier/context/CommandContext;)I", "handlePasswordInput", "handleKeyImport", "handleKeyGenerate", "handleSshConnect", "handleSshCommand", "", "Ljava/util/UUID;", "Lcom/jcraft/jsch/Session;", "activeSessions", "Ljava/util/Map;", "Lkotlin/Function1;", "pendingPasswords", "pendingFingerprints", "Ljava/io/File;", "sshKeysDir", "Ljava/io/File;", "knownHostsFile", "linuxssh"})
@SourceDebugExtension(value={"SMAP\nLinuxssh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Linuxssh.kt\ncn/moerain/linuxssh/Linuxssh\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,554:1\n13805#2,2:555\n1#3:557\n*S KotlinDebug\n*F\n+ 1 Linuxssh.kt\ncn/moerain/linuxssh/Linuxssh\n*L\n378#1:555,2\n*E\n"})
public final class Linuxssh
implements ModInitializer {
    @NotNull
    private final Map<UUID, Session> activeSessions = new LinkedHashMap();
    @NotNull
    private final Map<UUID, Function1<String, Unit>> pendingPasswords = new LinkedHashMap();
    @NotNull
    private final Map<UUID, Function1<Boolean, Unit>> pendingFingerprints = new LinkedHashMap();
    @NotNull
    private final File sshKeysDir = new File("config/linuxssh/keys");
    @NotNull
    private final File knownHostsFile = new File("config/linuxssh/known_hosts");

    public void onInitialize() {
        if (!this.sshKeysDir.exists()) {
            this.sshKeysDir.mkdirs();
        }
        if (!this.knownHostsFile.getParentFile().exists()) {
            this.knownHostsFile.getParentFile().mkdirs();
        }
        if (!this.knownHostsFile.exists()) {
            this.knownHostsFile.createNewFile();
        }
        LinuxsshConfig.Companion.getInstance();
        CommandRegistrationCallback.EVENT.register((arg_0, arg_1, arg_2) -> Linuxssh.onInitialize$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private final boolean deleteHostFingerprint(String host) {
        try {
            JSch jsch = new JSch();
            jsch.setKnownHosts(this.knownHostsFile.getAbsolutePath());
            HostKeyRepository hostKeyRepository = jsch.getHostKeyRepository();
            Object[] hostKeys = hostKeyRepository.getHostKey();
            boolean found = false;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])hostKeys);
            while (iterator.hasNext()) {
                HostKey hostKey = (HostKey)iterator.next();
                if (!Intrinsics.areEqual((Object)hostKey.getHost(), (Object)host)) continue;
                hostKeyRepository.remove(host, hostKey.getType());
                found = true;
                break;
            }
            return found;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final void registerSshCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ssh").then(class_2170.method_9247((String)"disconnect").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$1(this, arg_0)))).then(class_2170.method_9247((String)"password").then(class_2170.method_9244((String)"password", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$2(this, arg_0))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"confirm").then(class_2170.method_9247((String)"yes").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$3(this, arg_0)))).then(class_2170.method_9247((String)"no").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$4(this, arg_0))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"key").then(class_2170.method_9247((String)"import").then(class_2170.method_9244((String)"keypath", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$5(this, arg_0))))).then(class_2170.method_9247((String)"generate").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$6(this, arg_0))))).then(class_2170.method_9247((String)"connect").then(class_2170.method_9244((String)"connection", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$7(this, arg_0))))).then(class_2170.method_9247((String)"command").then(class_2170.method_9244((String)"command", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$8(this, arg_0)))));
    }

    private final int handleFingerprintConfirmation(CommandContext<class_2168> context, boolean confirmed) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            return 0;
        }
        class_3222 player = class_32222;
        Function1<Boolean, Unit> fingerprintCallback = this.pendingFingerprints.get(player.method_5667());
        if (fingerprintCallback != null) {
            fingerprintCallback.invoke((Object)confirmed);
            this.pendingFingerprints.remove(player.method_5667());
            if (confirmed) {
                source.method_9226(Linuxssh::handleFingerprintConfirmation$lambda$9, false);
            } else {
                source.method_9226(Linuxssh::handleFingerprintConfirmation$lambda$10, false);
            }
        } else {
            source.method_9226(Linuxssh::handleFingerprintConfirmation$lambda$11, false);
        }
        return 1;
    }

    private final int handleDisconnect(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            return 0;
        }
        class_3222 player = class_32222;
        Session session = this.activeSessions.get(player.method_5667());
        if (session != null && session.isConnected()) {
            session.disconnect();
            this.activeSessions.remove(player.method_5667());
            source.method_9226(Linuxssh::handleDisconnect$lambda$12, false);
        } else {
            source.method_9226(Linuxssh::handleDisconnect$lambda$13, false);
        }
        return 1;
    }

    private final int handlePasswordInput(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            return 0;
        }
        class_3222 player = class_32222;
        String password = StringArgumentType.getString(context, (String)"password");
        Function1<String, Unit> passwordCallback = this.pendingPasswords.get(player.method_5667());
        if (passwordCallback != null) {
            Intrinsics.checkNotNull((Object)password);
            passwordCallback.invoke((Object)password);
            this.pendingPasswords.remove(player.method_5667());
            source.method_9226(Linuxssh::handlePasswordInput$lambda$14, false);
        } else {
            source.method_9226(Linuxssh::handlePasswordInput$lambda$15, false);
        }
        return 1;
    }

    private final int handleKeyImport(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            return 0;
        }
        class_3222 player = class_32222;
        String keyPath = StringArgumentType.getString(context, (String)"keypath");
        CompletableFuture.runAsync(() -> Linuxssh.handleKeyImport$lambda$28(keyPath, source, this, player));
        return 1;
    }

    private final int handleKeyGenerate(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            return 0;
        }
        class_3222 player = class_32222;
        LinuxsshConfig config = LinuxsshConfig.Companion.getInstance();
        if (!config.getEnableKeyGeneration()) {
            source.method_9226(Linuxssh::handleKeyGenerate$lambda$29, false);
            return 1;
        }
        CompletableFuture.runAsync(() -> Linuxssh.handleKeyGenerate$lambda$39(this, player, source));
        return 1;
    }

    private final int handleSshConnect(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String connectionString = StringArgumentType.getString(context, (String)"connection");
        CompletableFuture.runAsync(() -> Linuxssh.handleSshConnect$lambda$58(connectionString, source, player, this));
        return 1;
    }

    private final int handleSshCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String command = StringArgumentType.getString(context, (String)"command");
        CompletableFuture.runAsync(() -> Linuxssh.handleSshCommand$lambda$64(player, source, command, this));
        return 1;
    }

    private static final void onInitialize$lambda$0(Linuxssh this$0, CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        this$0.registerSshCommand((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final int registerSshCommand$lambda$1(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleDisconnect((CommandContext<class_2168>)context);
    }

    private static final int registerSshCommand$lambda$2(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handlePasswordInput((CommandContext<class_2168>)context);
    }

    private static final int registerSshCommand$lambda$3(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleFingerprintConfirmation((CommandContext<class_2168>)context, true);
    }

    private static final int registerSshCommand$lambda$4(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleFingerprintConfirmation((CommandContext<class_2168>)context, false);
    }

    private static final int registerSshCommand$lambda$5(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleKeyImport((CommandContext<class_2168>)context);
    }

    private static final int registerSshCommand$lambda$6(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleKeyGenerate((CommandContext<class_2168>)context);
    }

    private static final int registerSshCommand$lambda$7(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleSshConnect((CommandContext<class_2168>)context);
    }

    private static final int registerSshCommand$lambda$8(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleSshCommand((CommandContext<class_2168>)context);
    }

    private static final class_2561 handleFingerprintConfirmation$lambda$9() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.fingerprint_accepted");
    }

    private static final class_2561 handleFingerprintConfirmation$lambda$10() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.fingerprint_rejected");
    }

    private static final class_2561 handleFingerprintConfirmation$lambda$11() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.not_connected");
    }

    private static final class_2561 handleDisconnect$lambda$12() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.disconnect");
    }

    private static final class_2561 handleDisconnect$lambda$13() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.not_connected");
    }

    private static final class_2561 handlePasswordInput$lambda$14() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.password_prompt");
    }

    private static final class_2561 handlePasswordInput$lambda$15() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.not_connected");
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$16(String $keyPath) {
        Object[] objectArray = new Object[]{$keyPath};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$18(String $errorMsg) {
        Object[] objectArray = new Object[]{$errorMsg};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$19(File $keyFile) {
        Object[] objectArray = new Object[]{$keyFile.getName()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_imported", (Object[])objectArray);
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$20() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.imported_content_header");
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$21(String $keyContent) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a" + $keyContent));
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$22() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.imported_content_footer");
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$23() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.imported_public_content_header");
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$24(String $publicKeyContent) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a" + $publicKeyContent));
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$25() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.imported_public_content_footer");
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$26(File $publicKeyFile) {
        Object[] objectArray = new Object[]{$publicKeyFile.getName()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_imported", (Object[])objectArray);
    }

    private static final class_2561 handleKeyImport$lambda$28$lambda$27(Exception $e) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final void handleKeyImport$lambda$28(String $keyPath, class_2168 $source, Linuxssh this$0, class_3222 $player) {
        try {
            File publicKeyFile;
            File keyFile = new File($keyPath);
            if (!keyFile.exists() || !keyFile.isFile()) {
                $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$16($keyPath), false);
                return;
            }
            File playerKeyDir = new File(this$0.sshKeysDir, $player.method_5667().toString());
            if (!playerKeyDir.exists()) {
                playerKeyDir.mkdirs();
            }
            JSch jsch = new JSch();
            try {
                jsch.addIdentity(keyFile.getAbsolutePath());
            }
            catch (JSchException e) {
                String string;
                String string2 = e.getMessage();
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    string = StringsKt.contains$default((CharSequence)it, (CharSequence)"[B@", (boolean)false, (int)2, null) ? "invalid privatekey format" : it;
                } else {
                    string = "unknown error";
                }
                String errorMsg = string;
                $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$18(errorMsg), false);
                return;
            }
            File targetFile = new File(playerKeyDir, keyFile.getName());
            FilesKt.copyTo$default((File)keyFile, (File)targetFile, (boolean)true, (int)0, (int)4, null);
            $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$19(keyFile), false);
            String keyContent = FilesKt.readText$default((File)keyFile, null, (int)1, null);
            $source.method_9226(Linuxssh::handleKeyImport$lambda$28$lambda$20, false);
            $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$21(keyContent), false);
            $source.method_9226(Linuxssh::handleKeyImport$lambda$28$lambda$22, false);
            String string = keyFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".pub", (boolean)false, (int)2, null) && (publicKeyFile = new File($keyPath + ".pub")).exists() && publicKeyFile.isFile()) {
                File targetPublicFile = new File(playerKeyDir, publicKeyFile.getName());
                FilesKt.copyTo$default((File)publicKeyFile, (File)targetPublicFile, (boolean)true, (int)0, (int)4, null);
                String publicKeyContent = FilesKt.readText$default((File)publicKeyFile, null, (int)1, null);
                $source.method_9226(Linuxssh::handleKeyImport$lambda$28$lambda$23, false);
                $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$24(publicKeyContent), false);
                $source.method_9226(Linuxssh::handleKeyImport$lambda$28$lambda$25, false);
                $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$26(publicKeyFile), false);
            }
        }
        catch (Exception e) {
            $source.method_9226(() -> Linuxssh.handleKeyImport$lambda$28$lambda$27(e), false);
            e.printStackTrace();
        }
    }

    private static final class_2561 handleKeyGenerate$lambda$29() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.key_generation_disabled");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$30() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.key_generated");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$31() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.generated_private_header");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$32(String $privateKeyContent) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a" + $privateKeyContent));
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$33() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.generated_private_footer");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$34() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.generated_public_header");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$35(String $publicKeyContent) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a" + $publicKeyContent));
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$36() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.key.generated_public_footer");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$37() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.key_usage_info");
    }

    private static final class_2561 handleKeyGenerate$lambda$39$lambda$38(Exception $e) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_generation_error", (Object[])objectArray);
    }

    private static final void handleKeyGenerate$lambda$39(Linuxssh this$0, class_3222 $player, class_2168 $source) {
        try {
            File playerKeyDir = new File(this$0.sshKeysDir, $player.method_5667().toString());
            if (!playerKeyDir.exists()) {
                playerKeyDir.mkdirs();
            }
            File privateKeyFile = new File(playerKeyDir, "id_rsa");
            File publicKeyFile = new File(playerKeyDir, "id_rsa.pub");
            KeyPair keyPair = KeyPair.genKeyPair((JSch)new JSch(), (int)2, (int)2048);
            keyPair.writePrivateKey((OutputStream)new FileOutputStream(privateKeyFile), new byte[0]);
            keyPair.writePublicKey((OutputStream)new FileOutputStream(publicKeyFile), "");
            keyPair.dispose();
            $source.method_9226(Linuxssh::handleKeyGenerate$lambda$39$lambda$30, false);
            String privateKeyContent = FilesKt.readText$default((File)privateKeyFile, null, (int)1, null);
            $source.method_9226(Linuxssh::handleKeyGenerate$lambda$39$lambda$31, false);
            $source.method_9226(() -> Linuxssh.handleKeyGenerate$lambda$39$lambda$32(privateKeyContent), false);
            $source.method_9226(Linuxssh::handleKeyGenerate$lambda$39$lambda$33, false);
            String publicKeyContent = FilesKt.readText$default((File)publicKeyFile, null, (int)1, null);
            $source.method_9226(Linuxssh::handleKeyGenerate$lambda$39$lambda$34, false);
            $source.method_9226(() -> Linuxssh.handleKeyGenerate$lambda$39$lambda$35(publicKeyContent), false);
            $source.method_9226(Linuxssh::handleKeyGenerate$lambda$39$lambda$36, false);
            $source.method_9226(Linuxssh::handleKeyGenerate$lambda$39$lambda$37, false);
        }
        catch (Exception e) {
            $source.method_9226(() -> Linuxssh.handleKeyGenerate$lambda$39$lambda$38(e), false);
            e.printStackTrace();
        }
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$40() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.invalid_format");
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$46$lambda$45$lambda$42(File $keyFile) {
        Object[] objectArray = new Object[]{$keyFile.getName()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_imported", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$46$lambda$45$lambda$44(String $errorMsg) {
        Object[] objectArray = new Object[]{$errorMsg};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$47(String $host) {
        Object[] objectArray = new Object[]{$host};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.fingerprint_deleted", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$48(String $username, String $host) {
        Object[] objectArray = new Object[]{$username + "@" + $host};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.connect", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$49(String $host) {
        Object[] objectArray = new Object[]{$host};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.connected", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$50() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.key_auth_failed");
    }

    private static final Unit handleSshConnect$lambda$58$lambda$51(CompletableFuture $passwordPromise, String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        $passwordPromise.complete(password);
        return Unit.INSTANCE;
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$52() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.password_prompt");
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$53(String $host) {
        Object[] objectArray = new Object[]{$host};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.connected", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$54(Exception $e) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.connection_failed", (Object[])objectArray);
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$56() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.invalid_format");
    }

    private static final class_2561 handleSshConnect$lambda$58$lambda$57(Exception $e) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.error", (Object[])objectArray);
    }

    private static final void handleSshConnect$lambda$58(String $connectionString, class_2168 $source, class_3222 $player, Linuxssh this$0) {
        block22: {
            try {
                block23: {
                    JSch jsch;
                    String host;
                    String username;
                    block24: {
                        Intrinsics.checkNotNull((Object)$connectionString);
                        if (!StringsKt.contains$default((CharSequence)$connectionString, (CharSequence)"@", (boolean)false, (int)2, null)) break block23;
                        String[] stringArray = new String[]{"@"};
                        List parts = StringsKt.split$default((CharSequence)$connectionString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        if (parts.size() != 2) {
                            $source.method_9226(Linuxssh::handleSshConnect$lambda$58$lambda$40, false);
                            return;
                        }
                        username = (String)parts.get(0);
                        host = (String)parts.get(1);
                        class_3222 class_32222 = $player;
                        if (class_32222 != null) {
                            class_3222 it = class_32222;
                            boolean bl = false;
                            Session session = this$0.activeSessions.get(it.method_5667());
                            if (session != null) {
                                session.disconnect();
                            }
                        }
                        jsch = new JSch();
                        jsch.setKnownHosts(this$0.knownHostsFile.getAbsolutePath());
                        class_3222 class_32223 = $player;
                        if (class_32223 == null) break block24;
                        class_3222 it = class_32223;
                        boolean bl = false;
                        File playerKeyDir = new File(this$0.sshKeysDir, it.method_5667().toString());
                        if (!playerKeyDir.exists() || !playerKeyDir.isDirectory()) break block24;
                        File[] fileArray = playerKeyDir.listFiles();
                        if (fileArray == null) break block24;
                        File[] $this$forEach$iv = fileArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            File element$iv;
                            File keyFile = element$iv = $this$forEach$iv[i];
                            boolean bl2 = false;
                            if (!keyFile.isFile()) continue;
                            try {
                                jsch.addIdentity(keyFile.getAbsolutePath());
                                $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$46$lambda$45$lambda$42(keyFile), false);
                                continue;
                            }
                            catch (JSchException e) {
                                String string;
                                block26: {
                                    block25: {
                                        string = e.getMessage();
                                        if (string == null) break block25;
                                        String it2 = string;
                                        boolean bl3 = false;
                                        String string2 = StringsKt.contains$default((CharSequence)it2, (CharSequence)"[B@", (boolean)false, (int)2, null) ? "invalid privatekey format" : it2;
                                        string = string2;
                                        if (string2 != null) break block26;
                                    }
                                    string = "unknown error";
                                }
                                String errorMsg = string;
                                $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$46$lambda$45$lambda$44(errorMsg), false);
                            }
                        }
                    }
                    LinuxsshConfig config = LinuxsshConfig.Companion.getInstance();
                    if (config.getDeleteHostFingerprint() && this$0.deleteHostFingerprint(host)) {
                        $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$47(host), false);
                    }
                    Session session = jsch.getSession(username, host, 22);
                    session.setConfig("StrictHostKeyChecking", "ask");
                    if ($player != null) {
                        session.setUserInfo(new UserInfo(this$0, $player, $source){
                            final /* synthetic */ Linuxssh this$0;
                            final /* synthetic */ class_3222 $player;
                            final /* synthetic */ class_2168 $source;
                            {
                                this.this$0 = $receiver;
                                this.$player = $player;
                                this.$source = $source;
                            }

                            public String getPassword() {
                                return null;
                            }

                            public boolean promptYesNo(String message) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                CompletableFuture<T> fingerprintPromise = new CompletableFuture<T>();
                                Linuxssh.access$getPendingFingerprints$p(this.this$0).put(this.$player.method_5667(), arg_0 -> handleSshConnect.1.5.promptYesNo$lambda$0(fingerprintPromise, arg_0));
                                String formattedMessage = StringsKt.replace$default((String)message, (String)"\n", (String)" ", (boolean)false, (int)4, null);
                                this.$source.method_9226(() -> handleSshConnect.1.5.promptYesNo$lambda$1(formattedMessage), false);
                                this.$source.method_9226(handleSshConnect.1.5::promptYesNo$lambda$2, false);
                                try {
                                    T t = fingerprintPromise.get();
                                    Intrinsics.checkNotNull(t);
                                    bl = (Boolean)t;
                                }
                                catch (Exception e) {
                                    this.$source.method_9226(handleSshConnect.1.5::promptYesNo$lambda$3, false);
                                    Linuxssh.access$getPendingFingerprints$p(this.this$0).remove(this.$player.method_5667());
                                    bl = false;
                                }
                                return bl;
                            }

                            public boolean promptPassword(String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                return true;
                            }

                            public boolean promptPassphrase(String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                return false;
                            }

                            public String getPassphrase() {
                                return null;
                            }

                            public void showMessage(String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                this.$source.method_9226(handleSshConnect.1.5::showMessage$lambda$4, false);
                            }

                            private static final Unit promptYesNo$lambda$0(CompletableFuture $fingerprintPromise, boolean confirmed) {
                                $fingerprintPromise.complete(confirmed);
                                return Unit.INSTANCE;
                            }

                            private static final class_2561 promptYesNo$lambda$1(String $formattedMessage) {
                                return (class_2561)class_2561.method_43470((String)("\u00a7e" + $formattedMessage));
                            }

                            private static final class_2561 promptYesNo$lambda$2() {
                                return (class_2561)class_2561.method_43471((String)"linuxssh.command.fingerprint_prompt");
                            }

                            private static final class_2561 promptYesNo$lambda$3() {
                                return (class_2561)class_2561.method_43471((String)"linuxssh.command.fingerprint_rejected");
                            }

                            private static final class_2561 showMessage$lambda$4() {
                                return (class_2561)class_2561.method_43471((String)"linuxssh.command.fingerprint_prompt");
                            }
                        });
                    }
                    $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$48(username, host), false);
                    boolean authSuccess = false;
                    if (config.getPreferKeyAuthentication()) {
                        try {
                            session.connect(5000);
                            authSuccess = true;
                            $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$49(host), false);
                        }
                        catch (Exception e) {
                            $source.method_9226(Linuxssh::handleSshConnect$lambda$58$lambda$50, false);
                        }
                    }
                    if (!authSuccess && $player != null) {
                        CompletableFuture passwordPromise = new CompletableFuture();
                        this$0.pendingPasswords.put($player.method_5667(), (Function1<String, Unit>)((Function1)arg_0 -> Linuxssh.handleSshConnect$lambda$58$lambda$51(passwordPromise, arg_0)));
                        $source.method_9226(Linuxssh::handleSshConnect$lambda$58$lambda$52, false);
                        try {
                            String password = (String)passwordPromise.get();
                            session.setPassword(password);
                            session.connect(30000);
                            authSuccess = true;
                            $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$53(host), false);
                        }
                        catch (Exception e) {
                            $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$54(e), false);
                            this$0.pendingPasswords.remove($player.method_5667());
                            return;
                        }
                    }
                    class_3222 class_32224 = $player;
                    if (class_32224 != null) {
                        class_3222 it = class_32224;
                        boolean bl = false;
                        this$0.activeSessions.put(it.method_5667(), session);
                    }
                    break block22;
                }
                $source.method_9226(Linuxssh::handleSshConnect$lambda$58$lambda$56, false);
            }
            catch (Exception e) {
                $source.method_9226(() -> Linuxssh.handleSshConnect$lambda$58$lambda$57(e), false);
                e.printStackTrace();
            }
        }
    }

    private static final class_2561 handleSshCommand$lambda$64$lambda$60() {
        return (class_2561)class_2561.method_43471((String)"linuxssh.command.not_connected");
    }

    private static final class_2561 handleSshCommand$lambda$64$lambda$62(Ref.ObjectRef $line) {
        Object[] objectArray = new Object[]{$line.element};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.command_output", (Object[])objectArray);
    }

    private static final class_2561 handleSshCommand$lambda$64$lambda$63(Exception $e) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        return (class_2561)class_2561.method_43469((String)"linuxssh.command.error", (Object[])objectArray);
    }

    private static final void handleSshCommand$lambda$64(class_3222 $player, class_2168 $source, String $command, Linuxssh this$0) {
        try {
            Session session;
            class_3222 class_32222 = $player;
            if (class_32222 != null) {
                class_3222 it = class_32222;
                boolean bl = false;
                v1 = this$0.activeSessions.get(it.method_5667());
            } else {
                v1 = session = null;
            }
            if (session == null || !session.isConnected()) {
                $source.method_9226(Linuxssh::handleSshCommand$lambda$64$lambda$60, false);
                return;
            }
            Channel channel = session.openChannel("exec");
            Intrinsics.checkNotNull((Object)channel, (String)"null cannot be cast to non-null type com.jcraft.jsch.ChannelExec");
            ChannelExec channel2 = (ChannelExec)channel;
            channel2.setCommand($command);
            InputStream inputStream = channel2.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            channel2.connect();
            Ref.ObjectRef line = new Ref.ObjectRef();
            while (true) {
                String string;
                String it = string = reader.readLine();
                boolean bl = false;
                line.element = it;
                if (string == null) break;
                $source.method_9226(() -> Linuxssh.handleSshCommand$lambda$64$lambda$62(line), false);
            }
            channel2.disconnect();
        }
        catch (Exception e) {
            $source.method_9226(() -> Linuxssh.handleSshCommand$lambda$64$lambda$63(e), false);
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ Map access$getPendingFingerprints$p(Linuxssh $this) {
        return $this.pendingFingerprints;
    }
}

