/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockBearTrap
extends FallingBlock {
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final MapCodec<BlockBearTrap> CODEC = BlockBearTrap.simpleCodec(BlockBearTrap::new);

    public BlockBearTrap(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CUSTOM_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlockBearTrap.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.below(), (Direction)Direction.DOWN);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn, InsideBlockEffectApplier effectApplier, boolean p_451772_) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            if (!entity.getActiveEffects().toString().contains(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)MobEffects.SLOWNESS.value())).getNamespace() + "." + BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)MobEffects.SLOWNESS.value())).getPath())) {
                entity.hurt(level.damageSources().generic(), 6.0f);
            }
            entity.hurt(level.damageSources().generic(), (float)Config.getBearTrapDamage());
            entity.makeStuckInBlock(state, new Vec3(0.1, 0.25, 0.1));
            if (!level.isClientSide()) {
                if (!entity.getActiveEffects().toString().contains(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)MobEffects.SLOWNESS.value())).getNamespace() + "." + BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)MobEffects.SLOWNESS.value())).getPath())) {
                    level.playSound((Entity)((Player)null), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 3.0f);
                }
                entity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 5, 0, false, false, false));
            }
        }
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public int getDustColor(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.defaultMapColor().calculateARGBColor(MapColor.Brightness.NORMAL);
    }
}

