/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.registry.ModBlocks;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockNailTrap
extends FallingBlock {
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final MapCodec<BlockNailTrap> CODEC = BlockNailTrap.simpleCodec(BlockNailTrap::new);

    public BlockNailTrap(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CUSTOM_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BlockNailTrap.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.DOWN);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn, InsideBlockEffectApplier effectApplier, boolean p_451772_) {
        if (!level.isClientSide() && !entityIn.isCrouching() && entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            if (this == ModBlocks.TOXIC_NAIL_TRAP.get()) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, Config.getToxicNailTrapEffectDuration(), Config.getToxicNailTrapEffectAmplifier()));
            }
            entity.hurt(level.damageSources().generic(), (float)Config.getNailTrapDamage());
        }
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public int getDustColor(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.defaultMapColor().calculateARGBColor(MapColor.Brightness.NORMAL);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }
}

