/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockQuicksand
extends FallingBlock {
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    public static final MapCodec<BlockQuicksand> CODEC = BlockQuicksand.simpleCodec(BlockQuicksand::new);

    public BlockQuicksand(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CUSTOM_SHAPE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn, InsideBlockEffectApplier effectApplier, boolean p_451772_) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            entity.makeStuckInBlock(state, new Vec3(0.25, 0.1, 0.25));
            if (entity.getEyePosition().y < (double)(pos.getY() + 1)) {
                entity.hurt(level.damageSources().inWall(), (float)Config.getQuicksandDamage());
            }
        }
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public int getDustColor(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.defaultMapColor().calculateARGBColor(MapColor.Brightness.NORMAL);
    }
}

